// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.ManagementGroupInner;
import java.io.IOException;
import java.util.List;

/**
 * The list workspace management groups operation response.
 */
@Fluent
public final class WorkspaceListManagementGroupsResult
    implements JsonSerializable<WorkspaceListManagementGroupsResult> {
    /*
     * Gets or sets a list of management groups attached to the workspace.
     */
    private List<ManagementGroupInner> value;

    /**
     * Creates an instance of WorkspaceListManagementGroupsResult class.
     */
    public WorkspaceListManagementGroupsResult() {
    }

    /**
     * Get the value property: Gets or sets a list of management groups attached to the workspace.
     * 
     * @return the value value.
     */
    public List<ManagementGroupInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets or sets a list of management groups attached to the workspace.
     * 
     * @param value the value value to set.
     * @return the WorkspaceListManagementGroupsResult object itself.
     */
    public WorkspaceListManagementGroupsResult withValue(List<ManagementGroupInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkspaceListManagementGroupsResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkspaceListManagementGroupsResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkspaceListManagementGroupsResult.
     */
    public static WorkspaceListManagementGroupsResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkspaceListManagementGroupsResult deserializedWorkspaceListManagementGroupsResult
                = new WorkspaceListManagementGroupsResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ManagementGroupInner> value
                        = reader.readArray(reader1 -> ManagementGroupInner.fromJson(reader1));
                    deserializedWorkspaceListManagementGroupsResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkspaceListManagementGroupsResult;
        });
    }
}
