// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * User-defined filters to return data which will be purged from the table.
 */
@Fluent
public final class WorkspacePurgeBodyFilters implements JsonSerializable<WorkspacePurgeBodyFilters> {
    /*
     * The column of the table over which the given query should run
     */
    private String column;

    /*
     * A query operator to evaluate over the provided column and value(s). Supported operators are ==, =~, in, in~, >,
     * >=, <, <=, between, and have the same behavior as they would in a KQL query.
     */
    private String operator;

    /*
     * the value for the operator to function over. This can be a number (e.g., > 100), a string (timestamp >=
     * '2017-09-01') or array of values.
     */
    private Object value;

    /*
     * When filtering over custom dimensions, this key will be used as the name of the custom dimension.
     */
    private String key;

    /**
     * Creates an instance of WorkspacePurgeBodyFilters class.
     */
    public WorkspacePurgeBodyFilters() {
    }

    /**
     * Get the column property: The column of the table over which the given query should run.
     * 
     * @return the column value.
     */
    public String column() {
        return this.column;
    }

    /**
     * Set the column property: The column of the table over which the given query should run.
     * 
     * @param column the column value to set.
     * @return the WorkspacePurgeBodyFilters object itself.
     */
    public WorkspacePurgeBodyFilters withColumn(String column) {
        this.column = column;
        return this;
    }

    /**
     * Get the operator property: A query operator to evaluate over the provided column and value(s). Supported
     * operators are ==, =~, in, in~, &gt;, &gt;=, &lt;, &lt;=, between, and have the same behavior as they would in a
     * KQL query.
     * 
     * @return the operator value.
     */
    public String operator() {
        return this.operator;
    }

    /**
     * Set the operator property: A query operator to evaluate over the provided column and value(s). Supported
     * operators are ==, =~, in, in~, &gt;, &gt;=, &lt;, &lt;=, between, and have the same behavior as they would in a
     * KQL query.
     * 
     * @param operator the operator value to set.
     * @return the WorkspacePurgeBodyFilters object itself.
     */
    public WorkspacePurgeBodyFilters withOperator(String operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the value property: the value for the operator to function over. This can be a number (e.g., &gt; 100), a
     * string (timestamp &gt;= '2017-09-01') or array of values.
     * 
     * @return the value value.
     */
    public Object value() {
        return this.value;
    }

    /**
     * Set the value property: the value for the operator to function over. This can be a number (e.g., &gt; 100), a
     * string (timestamp &gt;= '2017-09-01') or array of values.
     * 
     * @param value the value value to set.
     * @return the WorkspacePurgeBodyFilters object itself.
     */
    public WorkspacePurgeBodyFilters withValue(Object value) {
        this.value = value;
        return this;
    }

    /**
     * Get the key property: When filtering over custom dimensions, this key will be used as the name of the custom
     * dimension.
     * 
     * @return the key value.
     */
    public String key() {
        return this.key;
    }

    /**
     * Set the key property: When filtering over custom dimensions, this key will be used as the name of the custom
     * dimension.
     * 
     * @param key the key value to set.
     * @return the WorkspacePurgeBodyFilters object itself.
     */
    public WorkspacePurgeBodyFilters withKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("column", this.column);
        jsonWriter.writeStringField("operator", this.operator);
        jsonWriter.writeUntypedField("value", this.value);
        jsonWriter.writeStringField("key", this.key);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkspacePurgeBodyFilters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkspacePurgeBodyFilters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkspacePurgeBodyFilters.
     */
    public static WorkspacePurgeBodyFilters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkspacePurgeBodyFilters deserializedWorkspacePurgeBodyFilters = new WorkspacePurgeBodyFilters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("column".equals(fieldName)) {
                    deserializedWorkspacePurgeBodyFilters.column = reader.getString();
                } else if ("operator".equals(fieldName)) {
                    deserializedWorkspacePurgeBodyFilters.operator = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedWorkspacePurgeBodyFilters.value = reader.readUntyped();
                } else if ("key".equals(fieldName)) {
                    deserializedWorkspacePurgeBodyFilters.key = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkspacePurgeBodyFilters;
        });
    }
}
