// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;

/**
 * The WorkspacePurgesPurgeHeaders model.
 */
@Fluent
public final class WorkspacePurgesPurgeHeaders {
    /*
     * The x-ms-status-location property.
     */
    private String xMsStatusLocation;

    private static final HttpHeaderName X_MS_STATUS_LOCATION = HttpHeaderName.fromString("x-ms-status-location");

    // HttpHeaders containing the raw property values.
    /**
     * Creates an instance of WorkspacePurgesPurgeHeaders class.
     * 
     * @param rawHeaders The raw HttpHeaders that will be used to create the property values.
     */
    public WorkspacePurgesPurgeHeaders(HttpHeaders rawHeaders) {
        this.xMsStatusLocation = rawHeaders.getValue(X_MS_STATUS_LOCATION);
    }

    /**
     * Get the xMsStatusLocation property: The x-ms-status-location property.
     * 
     * @return the xMsStatusLocation value.
     */
    public String xMsStatusLocation() {
        return this.xMsStatusLocation;
    }

    /**
     * Set the xMsStatusLocation property: The x-ms-status-location property.
     * 
     * @param xMsStatusLocation the xMsStatusLocation value to set.
     * @return the WorkspacePurgesPurgeHeaders object itself.
     */
    public WorkspacePurgesPurgeHeaders withXMsStatusLocation(String xMsStatusLocation) {
        this.xMsStatusLocation = xMsStatusLocation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
