// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The SKU (tier) of a workspace.
 */
@Fluent
public final class WorkspaceSku implements JsonSerializable<WorkspaceSku> {
    /*
     * The name of the SKU.
     */
    private WorkspaceSkuNameEnum name;

    /*
     * The capacity reservation level in GB for this workspace, when CapacityReservation sku is selected.
     */
    private CapacityReservationLevel capacityReservationLevel;

    /*
     * The last time when the sku was updated.
     */
    private String lastSkuUpdate;

    /**
     * Creates an instance of WorkspaceSku class.
     */
    public WorkspaceSku() {
    }

    /**
     * Get the name property: The name of the SKU.
     * 
     * @return the name value.
     */
    public WorkspaceSkuNameEnum name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the SKU.
     * 
     * @param name the name value to set.
     * @return the WorkspaceSku object itself.
     */
    public WorkspaceSku withName(WorkspaceSkuNameEnum name) {
        this.name = name;
        return this;
    }

    /**
     * Get the capacityReservationLevel property: The capacity reservation level in GB for this workspace, when
     * CapacityReservation sku is selected.
     * 
     * @return the capacityReservationLevel value.
     */
    public CapacityReservationLevel capacityReservationLevel() {
        return this.capacityReservationLevel;
    }

    /**
     * Set the capacityReservationLevel property: The capacity reservation level in GB for this workspace, when
     * CapacityReservation sku is selected.
     * 
     * @param capacityReservationLevel the capacityReservationLevel value to set.
     * @return the WorkspaceSku object itself.
     */
    public WorkspaceSku withCapacityReservationLevel(CapacityReservationLevel capacityReservationLevel) {
        this.capacityReservationLevel = capacityReservationLevel;
        return this;
    }

    /**
     * Get the lastSkuUpdate property: The last time when the sku was updated.
     * 
     * @return the lastSkuUpdate value.
     */
    public String lastSkuUpdate() {
        return this.lastSkuUpdate;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model WorkspaceSku"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceSku.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeNumberField("capacityReservationLevel",
            this.capacityReservationLevel == null ? null : this.capacityReservationLevel.toInt());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkspaceSku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkspaceSku if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WorkspaceSku.
     */
    public static WorkspaceSku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkspaceSku deserializedWorkspaceSku = new WorkspaceSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedWorkspaceSku.name = WorkspaceSkuNameEnum.fromString(reader.getString());
                } else if ("capacityReservationLevel".equals(fieldName)) {
                    deserializedWorkspaceSku.capacityReservationLevel
                        = CapacityReservationLevel.fromInt(reader.getInt());
                } else if ("lastSkuUpdate".equals(fieldName)) {
                    deserializedWorkspaceSku.lastSkuUpdate = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkspaceSku;
        });
    }
}
