/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.fluent.OperationalInsightsManagementClient;
import com.azure.resourcemanager.loganalytics.implementation.AvailableServiceTiersImpl;
import com.azure.resourcemanager.loganalytics.implementation.ClustersImpl;
import com.azure.resourcemanager.loganalytics.implementation.DataExportsImpl;
import com.azure.resourcemanager.loganalytics.implementation.DataSourcesImpl;
import com.azure.resourcemanager.loganalytics.implementation.DeletedWorkspacesImpl;
import com.azure.resourcemanager.loganalytics.implementation.GatewaysImpl;
import com.azure.resourcemanager.loganalytics.implementation.IntelligencePacksImpl;
import com.azure.resourcemanager.loganalytics.implementation.LinkedServicesImpl;
import com.azure.resourcemanager.loganalytics.implementation.LinkedStorageAccountsImpl;
import com.azure.resourcemanager.loganalytics.implementation.ManagementGroupsImpl;
import com.azure.resourcemanager.loganalytics.implementation.OperationStatusesImpl;
import com.azure.resourcemanager.loganalytics.implementation.OperationalInsightsManagementClientBuilder;
import com.azure.resourcemanager.loganalytics.implementation.OperationsImpl;
import com.azure.resourcemanager.loganalytics.implementation.QueriesImpl;
import com.azure.resourcemanager.loganalytics.implementation.QueryPacksImpl;
import com.azure.resourcemanager.loganalytics.implementation.SavedSearchesImpl;
import com.azure.resourcemanager.loganalytics.implementation.SchemasImpl;
import com.azure.resourcemanager.loganalytics.implementation.SharedKeysOperationsImpl;
import com.azure.resourcemanager.loganalytics.implementation.StorageInsightConfigsImpl;
import com.azure.resourcemanager.loganalytics.implementation.TablesImpl;
import com.azure.resourcemanager.loganalytics.implementation.UsagesImpl;
import com.azure.resourcemanager.loganalytics.implementation.WorkspacePurgesImpl;
import com.azure.resourcemanager.loganalytics.implementation.WorkspacesImpl;
import com.azure.resourcemanager.loganalytics.models.AvailableServiceTiers;
import com.azure.resourcemanager.loganalytics.models.Clusters;
import com.azure.resourcemanager.loganalytics.models.DataExports;
import com.azure.resourcemanager.loganalytics.models.DataSources;
import com.azure.resourcemanager.loganalytics.models.DeletedWorkspaces;
import com.azure.resourcemanager.loganalytics.models.Gateways;
import com.azure.resourcemanager.loganalytics.models.IntelligencePacks;
import com.azure.resourcemanager.loganalytics.models.LinkedServices;
import com.azure.resourcemanager.loganalytics.models.LinkedStorageAccounts;
import com.azure.resourcemanager.loganalytics.models.ManagementGroups;
import com.azure.resourcemanager.loganalytics.models.OperationStatuses;
import com.azure.resourcemanager.loganalytics.models.Operations;
import com.azure.resourcemanager.loganalytics.models.Queries;
import com.azure.resourcemanager.loganalytics.models.QueryPacks;
import com.azure.resourcemanager.loganalytics.models.SavedSearches;
import com.azure.resourcemanager.loganalytics.models.Schemas;
import com.azure.resourcemanager.loganalytics.models.SharedKeysOperations;
import com.azure.resourcemanager.loganalytics.models.StorageInsightConfigs;
import com.azure.resourcemanager.loganalytics.models.Tables;
import com.azure.resourcemanager.loganalytics.models.Usages;
import com.azure.resourcemanager.loganalytics.models.WorkspacePurges;
import com.azure.resourcemanager.loganalytics.models.Workspaces;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class LogAnalyticsManager {
    private QueryPacks queryPacks;
    private Queries queries;
    private DataExports dataExports;
    private DataSources dataSources;
    private IntelligencePacks intelligencePacks;
    private LinkedServices linkedServices;
    private LinkedStorageAccounts linkedStorageAccounts;
    private ManagementGroups managementGroups;
    private OperationStatuses operationStatuses;
    private SharedKeysOperations sharedKeysOperations;
    private Usages usages;
    private StorageInsightConfigs storageInsightConfigs;
    private SavedSearches savedSearches;
    private AvailableServiceTiers availableServiceTiers;
    private Gateways gateways;
    private Schemas schemas;
    private WorkspacePurges workspacePurges;
    private Clusters clusters;
    private Operations operations;
    private Workspaces workspaces;
    private DeletedWorkspaces deletedWorkspaces;
    private Tables tables;
    private final OperationalInsightsManagementClient clientObject;

    private LogAnalyticsManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new OperationalInsightsManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static LogAnalyticsManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return LogAnalyticsManager.configure().authenticate(credential, profile);
    }

    public static LogAnalyticsManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new LogAnalyticsManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public QueryPacks queryPacks() {
        if (this.queryPacks == null) {
            this.queryPacks = new QueryPacksImpl(this.clientObject.getQueryPacks(), this);
        }
        return this.queryPacks;
    }

    public Queries queries() {
        if (this.queries == null) {
            this.queries = new QueriesImpl(this.clientObject.getQueries(), this);
        }
        return this.queries;
    }

    public DataExports dataExports() {
        if (this.dataExports == null) {
            this.dataExports = new DataExportsImpl(this.clientObject.getDataExports(), this);
        }
        return this.dataExports;
    }

    public DataSources dataSources() {
        if (this.dataSources == null) {
            this.dataSources = new DataSourcesImpl(this.clientObject.getDataSources(), this);
        }
        return this.dataSources;
    }

    public IntelligencePacks intelligencePacks() {
        if (this.intelligencePacks == null) {
            this.intelligencePacks = new IntelligencePacksImpl(this.clientObject.getIntelligencePacks(), this);
        }
        return this.intelligencePacks;
    }

    public LinkedServices linkedServices() {
        if (this.linkedServices == null) {
            this.linkedServices = new LinkedServicesImpl(this.clientObject.getLinkedServices(), this);
        }
        return this.linkedServices;
    }

    public LinkedStorageAccounts linkedStorageAccounts() {
        if (this.linkedStorageAccounts == null) {
            this.linkedStorageAccounts = new LinkedStorageAccountsImpl(this.clientObject.getLinkedStorageAccounts(), this);
        }
        return this.linkedStorageAccounts;
    }

    public ManagementGroups managementGroups() {
        if (this.managementGroups == null) {
            this.managementGroups = new ManagementGroupsImpl(this.clientObject.getManagementGroups(), this);
        }
        return this.managementGroups;
    }

    public OperationStatuses operationStatuses() {
        if (this.operationStatuses == null) {
            this.operationStatuses = new OperationStatusesImpl(this.clientObject.getOperationStatuses(), this);
        }
        return this.operationStatuses;
    }

    public SharedKeysOperations sharedKeysOperations() {
        if (this.sharedKeysOperations == null) {
            this.sharedKeysOperations = new SharedKeysOperationsImpl(this.clientObject.getSharedKeysOperations(), this);
        }
        return this.sharedKeysOperations;
    }

    public Usages usages() {
        if (this.usages == null) {
            this.usages = new UsagesImpl(this.clientObject.getUsages(), this);
        }
        return this.usages;
    }

    public StorageInsightConfigs storageInsightConfigs() {
        if (this.storageInsightConfigs == null) {
            this.storageInsightConfigs = new StorageInsightConfigsImpl(this.clientObject.getStorageInsightConfigs(), this);
        }
        return this.storageInsightConfigs;
    }

    public SavedSearches savedSearches() {
        if (this.savedSearches == null) {
            this.savedSearches = new SavedSearchesImpl(this.clientObject.getSavedSearches(), this);
        }
        return this.savedSearches;
    }

    public AvailableServiceTiers availableServiceTiers() {
        if (this.availableServiceTiers == null) {
            this.availableServiceTiers = new AvailableServiceTiersImpl(this.clientObject.getAvailableServiceTiers(), this);
        }
        return this.availableServiceTiers;
    }

    public Gateways gateways() {
        if (this.gateways == null) {
            this.gateways = new GatewaysImpl(this.clientObject.getGateways(), this);
        }
        return this.gateways;
    }

    public Schemas schemas() {
        if (this.schemas == null) {
            this.schemas = new SchemasImpl(this.clientObject.getSchemas(), this);
        }
        return this.schemas;
    }

    public WorkspacePurges workspacePurges() {
        if (this.workspacePurges == null) {
            this.workspacePurges = new WorkspacePurgesImpl(this.clientObject.getWorkspacePurges(), this);
        }
        return this.workspacePurges;
    }

    public Clusters clusters() {
        if (this.clusters == null) {
            this.clusters = new ClustersImpl(this.clientObject.getClusters(), this);
        }
        return this.clusters;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public Workspaces workspaces() {
        if (this.workspaces == null) {
            this.workspaces = new WorkspacesImpl(this.clientObject.getWorkspaces(), this);
        }
        return this.workspaces;
    }

    public DeletedWorkspaces deletedWorkspaces() {
        if (this.deletedWorkspaces == null) {
            this.deletedWorkspaces = new DeletedWorkspacesImpl(this.clientObject.getDeletedWorkspaces(), this);
        }
        return this.deletedWorkspaces;
    }

    public Tables tables() {
        if (this.tables == null) {
            this.tables = new TablesImpl(this.clientObject.getTables(), this);
        }
        return this.tables;
    }

    public OperationalInsightsManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public LogAnalyticsManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.loganalytics").append("/").append("1.1.0");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new LogAnalyticsManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

