/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.ClusterProperties;
import com.azure.resourcemanager.loganalytics.models.AssociatedWorkspace;
import com.azure.resourcemanager.loganalytics.models.BillingType;
import com.azure.resourcemanager.loganalytics.models.CapacityReservationProperties;
import com.azure.resourcemanager.loganalytics.models.ClusterEntityStatus;
import com.azure.resourcemanager.loganalytics.models.ClusterSku;
import com.azure.resourcemanager.loganalytics.models.KeyVaultProperties;
import com.azure.resourcemanager.loganalytics.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ClusterInner
extends Resource {
    private ManagedServiceIdentity identity;
    private ClusterSku sku;
    private ClusterProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ClusterInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public ClusterSku sku() {
        return this.sku;
    }

    public ClusterInner withSku(ClusterSku sku) {
        this.sku = sku;
        return this;
    }

    private ClusterProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ClusterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ClusterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String clusterId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterId();
    }

    public ClusterEntityStatus provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Boolean isDoubleEncryptionEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isDoubleEncryptionEnabled();
    }

    public ClusterInner withIsDoubleEncryptionEnabled(Boolean isDoubleEncryptionEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withIsDoubleEncryptionEnabled(isDoubleEncryptionEnabled);
        return this;
    }

    public Boolean isAvailabilityZonesEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isAvailabilityZonesEnabled();
    }

    public ClusterInner withIsAvailabilityZonesEnabled(Boolean isAvailabilityZonesEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withIsAvailabilityZonesEnabled(isAvailabilityZonesEnabled);
        return this;
    }

    public BillingType billingType() {
        return this.innerProperties() == null ? null : this.innerProperties().billingType();
    }

    public ClusterInner withBillingType(BillingType billingType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withBillingType(billingType);
        return this;
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultProperties();
    }

    public ClusterInner withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withKeyVaultProperties(keyVaultProperties);
        return this;
    }

    public String lastModifiedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedDate();
    }

    public String createdDate() {
        return this.innerProperties() == null ? null : this.innerProperties().createdDate();
    }

    public List<AssociatedWorkspace> associatedWorkspaces() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedWorkspaces();
    }

    public ClusterInner withAssociatedWorkspaces(List<AssociatedWorkspace> associatedWorkspaces) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withAssociatedWorkspaces(associatedWorkspaces);
        return this;
    }

    public CapacityReservationProperties capacityReservationProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().capacityReservationProperties();
    }

    public ClusterInner withCapacityReservationProperties(CapacityReservationProperties capacityReservationProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withCapacityReservationProperties(capacityReservationProperties);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ClusterInner fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterInner)((Object)jsonReader.readObject(reader -> {
            ClusterInner deserializedClusterInner = new ClusterInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedClusterInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedClusterInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedClusterInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedClusterInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedClusterInner.withTags(tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedClusterInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedClusterInner.sku = ClusterSku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedClusterInner.innerProperties = ClusterProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterInner;
        }));
    }
}

