/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.BillingType;
import com.azure.resourcemanager.loganalytics.models.KeyVaultProperties;
import java.io.IOException;

public final class ClusterPatchProperties
implements JsonSerializable<ClusterPatchProperties> {
    private KeyVaultProperties keyVaultProperties;
    private BillingType billingType;

    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public ClusterPatchProperties withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public BillingType billingType() {
        return this.billingType;
    }

    public ClusterPatchProperties withBillingType(BillingType billingType) {
        this.billingType = billingType;
        return this;
    }

    public void validate() {
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("keyVaultProperties", (JsonSerializable)this.keyVaultProperties);
        jsonWriter.writeStringField("billingType", this.billingType == null ? null : this.billingType.toString());
        return jsonWriter.writeEndObject();
    }

    public static ClusterPatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterPatchProperties)jsonReader.readObject(reader -> {
            ClusterPatchProperties deserializedClusterPatchProperties = new ClusterPatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultProperties".equals(fieldName)) {
                    deserializedClusterPatchProperties.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                    continue;
                }
                if ("billingType".equals(fieldName)) {
                    deserializedClusterPatchProperties.billingType = BillingType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterPatchProperties;
        });
    }
}

