/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.AssociatedWorkspace;
import com.azure.resourcemanager.loganalytics.models.BillingType;
import com.azure.resourcemanager.loganalytics.models.CapacityReservationProperties;
import com.azure.resourcemanager.loganalytics.models.ClusterEntityStatus;
import com.azure.resourcemanager.loganalytics.models.KeyVaultProperties;
import java.io.IOException;
import java.util.List;

public final class ClusterProperties
implements JsonSerializable<ClusterProperties> {
    private String clusterId;
    private ClusterEntityStatus provisioningState;
    private Boolean isDoubleEncryptionEnabled;
    private Boolean isAvailabilityZonesEnabled;
    private BillingType billingType;
    private KeyVaultProperties keyVaultProperties;
    private String lastModifiedDate;
    private String createdDate;
    private List<AssociatedWorkspace> associatedWorkspaces;
    private CapacityReservationProperties capacityReservationProperties;

    public String clusterId() {
        return this.clusterId;
    }

    public ClusterEntityStatus provisioningState() {
        return this.provisioningState;
    }

    public Boolean isDoubleEncryptionEnabled() {
        return this.isDoubleEncryptionEnabled;
    }

    public ClusterProperties withIsDoubleEncryptionEnabled(Boolean isDoubleEncryptionEnabled) {
        this.isDoubleEncryptionEnabled = isDoubleEncryptionEnabled;
        return this;
    }

    public Boolean isAvailabilityZonesEnabled() {
        return this.isAvailabilityZonesEnabled;
    }

    public ClusterProperties withIsAvailabilityZonesEnabled(Boolean isAvailabilityZonesEnabled) {
        this.isAvailabilityZonesEnabled = isAvailabilityZonesEnabled;
        return this;
    }

    public BillingType billingType() {
        return this.billingType;
    }

    public ClusterProperties withBillingType(BillingType billingType) {
        this.billingType = billingType;
        return this;
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public ClusterProperties withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String createdDate() {
        return this.createdDate;
    }

    public List<AssociatedWorkspace> associatedWorkspaces() {
        return this.associatedWorkspaces;
    }

    public ClusterProperties withAssociatedWorkspaces(List<AssociatedWorkspace> associatedWorkspaces) {
        this.associatedWorkspaces = associatedWorkspaces;
        return this;
    }

    public CapacityReservationProperties capacityReservationProperties() {
        return this.capacityReservationProperties;
    }

    public ClusterProperties withCapacityReservationProperties(CapacityReservationProperties capacityReservationProperties) {
        this.capacityReservationProperties = capacityReservationProperties;
        return this;
    }

    public void validate() {
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
        if (this.associatedWorkspaces() != null) {
            this.associatedWorkspaces().forEach(e -> e.validate());
        }
        if (this.capacityReservationProperties() != null) {
            this.capacityReservationProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isDoubleEncryptionEnabled", this.isDoubleEncryptionEnabled);
        jsonWriter.writeBooleanField("isAvailabilityZonesEnabled", this.isAvailabilityZonesEnabled);
        jsonWriter.writeStringField("billingType", this.billingType == null ? null : this.billingType.toString());
        jsonWriter.writeJsonField("keyVaultProperties", (JsonSerializable)this.keyVaultProperties);
        jsonWriter.writeArrayField("associatedWorkspaces", this.associatedWorkspaces, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("capacityReservationProperties", (JsonSerializable)this.capacityReservationProperties);
        return jsonWriter.writeEndObject();
    }

    public static ClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterProperties)jsonReader.readObject(reader -> {
            ClusterProperties deserializedClusterProperties = new ClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clusterId".equals(fieldName)) {
                    deserializedClusterProperties.clusterId = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedClusterProperties.provisioningState = ClusterEntityStatus.fromString(reader.getString());
                    continue;
                }
                if ("isDoubleEncryptionEnabled".equals(fieldName)) {
                    deserializedClusterProperties.isDoubleEncryptionEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isAvailabilityZonesEnabled".equals(fieldName)) {
                    deserializedClusterProperties.isAvailabilityZonesEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("billingType".equals(fieldName)) {
                    deserializedClusterProperties.billingType = BillingType.fromString(reader.getString());
                    continue;
                }
                if ("keyVaultProperties".equals(fieldName)) {
                    deserializedClusterProperties.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                    continue;
                }
                if ("lastModifiedDate".equals(fieldName)) {
                    deserializedClusterProperties.lastModifiedDate = reader.getString();
                    continue;
                }
                if ("createdDate".equals(fieldName)) {
                    deserializedClusterProperties.createdDate = reader.getString();
                    continue;
                }
                if ("associatedWorkspaces".equals(fieldName)) {
                    List associatedWorkspaces;
                    deserializedClusterProperties.associatedWorkspaces = associatedWorkspaces = reader.readArray(reader1 -> AssociatedWorkspace.fromJson(reader1));
                    continue;
                }
                if ("capacityReservationProperties".equals(fieldName)) {
                    deserializedClusterProperties.capacityReservationProperties = CapacityReservationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterProperties;
        });
    }
}

