/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.DataExportProperties;
import com.azure.resourcemanager.loganalytics.models.Type;
import java.io.IOException;
import java.util.List;

public final class DataExportInner
extends ProxyResource {
    private DataExportProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private DataExportProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String dataExportId() {
        return this.innerProperties() == null ? null : this.innerProperties().dataExportId();
    }

    public DataExportInner withDataExportId(String dataExportId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataExportProperties();
        }
        this.innerProperties().withDataExportId(dataExportId);
        return this;
    }

    public List<String> tableNames() {
        return this.innerProperties() == null ? null : this.innerProperties().tableNames();
    }

    public DataExportInner withTableNames(List<String> tableNames) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataExportProperties();
        }
        this.innerProperties().withTableNames(tableNames);
        return this;
    }

    public Boolean enable() {
        return this.innerProperties() == null ? null : this.innerProperties().enable();
    }

    public DataExportInner withEnable(Boolean enable) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataExportProperties();
        }
        this.innerProperties().withEnable(enable);
        return this;
    }

    public String createdDate() {
        return this.innerProperties() == null ? null : this.innerProperties().createdDate();
    }

    public DataExportInner withCreatedDate(String createdDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataExportProperties();
        }
        this.innerProperties().withCreatedDate(createdDate);
        return this;
    }

    public String lastModifiedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedDate();
    }

    public DataExportInner withLastModifiedDate(String lastModifiedDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataExportProperties();
        }
        this.innerProperties().withLastModifiedDate(lastModifiedDate);
        return this;
    }

    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    public DataExportInner withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataExportProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    public Type typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    public String eventHubName() {
        return this.innerProperties() == null ? null : this.innerProperties().eventHubName();
    }

    public DataExportInner withEventHubName(String eventHubName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataExportProperties();
        }
        this.innerProperties().withEventHubName(eventHubName);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DataExportInner fromJson(JsonReader jsonReader) throws IOException {
        return (DataExportInner)((Object)jsonReader.readObject(reader -> {
            DataExportInner deserializedDataExportInner = new DataExportInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDataExportInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDataExportInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDataExportInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDataExportInner.innerProperties = DataExportProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataExportInner;
        }));
    }
}

