/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.Destination;
import com.azure.resourcemanager.loganalytics.models.Type;
import java.io.IOException;
import java.util.List;

public final class DataExportProperties
implements JsonSerializable<DataExportProperties> {
    private String dataExportId;
    private List<String> tableNames;
    private Destination innerDestination;
    private Boolean enable;
    private String createdDate;
    private String lastModifiedDate;
    private static final ClientLogger LOGGER = new ClientLogger(DataExportProperties.class);

    public String dataExportId() {
        return this.dataExportId;
    }

    public DataExportProperties withDataExportId(String dataExportId) {
        this.dataExportId = dataExportId;
        return this;
    }

    public List<String> tableNames() {
        return this.tableNames;
    }

    public DataExportProperties withTableNames(List<String> tableNames) {
        this.tableNames = tableNames;
        return this;
    }

    private Destination innerDestination() {
        return this.innerDestination;
    }

    public Boolean enable() {
        return this.enable;
    }

    public DataExportProperties withEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    public String createdDate() {
        return this.createdDate;
    }

    public DataExportProperties withCreatedDate(String createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public DataExportProperties withLastModifiedDate(String lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
        return this;
    }

    public String resourceId() {
        return this.innerDestination() == null ? null : this.innerDestination().resourceId();
    }

    public DataExportProperties withResourceId(String resourceId) {
        if (this.innerDestination() == null) {
            this.innerDestination = new Destination();
        }
        this.innerDestination().withResourceId(resourceId);
        return this;
    }

    public Type type() {
        return this.innerDestination() == null ? null : this.innerDestination().type();
    }

    public String eventHubName() {
        return this.innerDestination() == null ? null : this.innerDestination().eventHubName();
    }

    public DataExportProperties withEventHubName(String eventHubName) {
        if (this.innerDestination() == null) {
            this.innerDestination = new Destination();
        }
        this.innerDestination().withEventHubName(eventHubName);
        return this;
    }

    public void validate() {
        if (this.tableNames() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tableNames in model DataExportProperties"));
        }
        if (this.innerDestination() != null) {
            this.innerDestination().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tableNames", this.tableNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("dataExportId", this.dataExportId);
        jsonWriter.writeJsonField("destination", (JsonSerializable)this.innerDestination);
        jsonWriter.writeBooleanField("enable", this.enable);
        jsonWriter.writeStringField("createdDate", this.createdDate);
        jsonWriter.writeStringField("lastModifiedDate", this.lastModifiedDate);
        return jsonWriter.writeEndObject();
    }

    public static DataExportProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DataExportProperties)jsonReader.readObject(reader -> {
            DataExportProperties deserializedDataExportProperties = new DataExportProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tableNames".equals(fieldName)) {
                    List tableNames;
                    deserializedDataExportProperties.tableNames = tableNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("dataExportId".equals(fieldName)) {
                    deserializedDataExportProperties.dataExportId = reader.getString();
                    continue;
                }
                if ("destination".equals(fieldName)) {
                    deserializedDataExportProperties.innerDestination = Destination.fromJson(reader);
                    continue;
                }
                if ("enable".equals(fieldName)) {
                    deserializedDataExportProperties.enable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("createdDate".equals(fieldName)) {
                    deserializedDataExportProperties.createdDate = reader.getString();
                    continue;
                }
                if ("lastModifiedDate".equals(fieldName)) {
                    deserializedDataExportProperties.lastModifiedDate = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataExportProperties;
        });
    }
}

