/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.DataSourceKind;
import java.io.IOException;
import java.util.Map;

public final class DataSourceInner
extends ProxyResource {
    private Object properties;
    private String etag;
    private DataSourceKind kind;
    private Map<String, String> tags;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(DataSourceInner.class);

    public Object properties() {
        return this.properties;
    }

    public DataSourceInner withProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public DataSourceInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public DataSourceKind kind() {
        return this.kind;
    }

    public DataSourceInner withKind(DataSourceKind kind) {
        this.kind = kind;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DataSourceInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model DataSourceInner"));
        }
        if (this.kind() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property kind in model DataSourceInner"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("properties", this.properties);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DataSourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (DataSourceInner)((Object)jsonReader.readObject(reader -> {
            DataSourceInner deserializedDataSourceInner = new DataSourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDataSourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDataSourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDataSourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDataSourceInner.properties = reader.readUntyped();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDataSourceInner.kind = DataSourceKind.fromString(reader.getString());
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDataSourceInner.etag = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDataSourceInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataSourceInner;
        }));
    }
}

