/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.DestinationMetadata;
import com.azure.resourcemanager.loganalytics.models.Type;
import java.io.IOException;

public final class Destination
implements JsonSerializable<Destination> {
    private String resourceId;
    private Type type;
    private DestinationMetadata innerMetadata;
    private static final ClientLogger LOGGER = new ClientLogger(Destination.class);

    public String resourceId() {
        return this.resourceId;
    }

    public Destination withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public Type type() {
        return this.type;
    }

    private DestinationMetadata innerMetadata() {
        return this.innerMetadata;
    }

    public String eventHubName() {
        return this.innerMetadata() == null ? null : this.innerMetadata().eventHubName();
    }

    public Destination withEventHubName(String eventHubName) {
        if (this.innerMetadata() == null) {
            this.innerMetadata = new DestinationMetadata();
        }
        this.innerMetadata().withEventHubName(eventHubName);
        return this;
    }

    public void validate() {
        if (this.resourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceId in model Destination"));
        }
        if (this.innerMetadata() != null) {
            this.innerMetadata().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeJsonField("metaData", (JsonSerializable)this.innerMetadata);
        return jsonWriter.writeEndObject();
    }

    public static Destination fromJson(JsonReader jsonReader) throws IOException {
        return (Destination)jsonReader.readObject(reader -> {
            Destination deserializedDestination = new Destination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedDestination.resourceId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDestination.type = Type.fromString(reader.getString());
                    continue;
                }
                if ("metaData".equals(fieldName)) {
                    deserializedDestination.innerMetadata = DestinationMetadata.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDestination;
        });
    }
}

