/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.LinkedServiceProperties;
import com.azure.resourcemanager.loganalytics.models.LinkedServiceEntityStatus;
import java.io.IOException;
import java.util.Map;

public final class LinkedServiceInner
extends ProxyResource {
    private LinkedServiceProperties innerProperties = new LinkedServiceProperties();
    private Map<String, String> tags;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(LinkedServiceInner.class);

    private LinkedServiceProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public LinkedServiceInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    public LinkedServiceInner withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LinkedServiceProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    public String writeAccessResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().writeAccessResourceId();
    }

    public LinkedServiceInner withWriteAccessResourceId(String writeAccessResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LinkedServiceProperties();
        }
        this.innerProperties().withWriteAccessResourceId(writeAccessResourceId);
        return this;
    }

    public LinkedServiceEntityStatus provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public LinkedServiceInner withProvisioningState(LinkedServiceEntityStatus provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LinkedServiceProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model LinkedServiceInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static LinkedServiceInner fromJson(JsonReader jsonReader) throws IOException {
        return (LinkedServiceInner)((Object)jsonReader.readObject(reader -> {
            LinkedServiceInner deserializedLinkedServiceInner = new LinkedServiceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLinkedServiceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedLinkedServiceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLinkedServiceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedLinkedServiceInner.innerProperties = LinkedServiceProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedLinkedServiceInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkedServiceInner;
        }));
    }
}

