/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.LinkedServiceEntityStatus;
import java.io.IOException;

public final class LinkedServiceProperties
implements JsonSerializable<LinkedServiceProperties> {
    private String resourceId;
    private String writeAccessResourceId;
    private LinkedServiceEntityStatus provisioningState;

    public String resourceId() {
        return this.resourceId;
    }

    public LinkedServiceProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String writeAccessResourceId() {
        return this.writeAccessResourceId;
    }

    public LinkedServiceProperties withWriteAccessResourceId(String writeAccessResourceId) {
        this.writeAccessResourceId = writeAccessResourceId;
        return this;
    }

    public LinkedServiceEntityStatus provisioningState() {
        return this.provisioningState;
    }

    public LinkedServiceProperties withProvisioningState(LinkedServiceEntityStatus provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("writeAccessResourceId", this.writeAccessResourceId);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        return jsonWriter.writeEndObject();
    }

    public static LinkedServiceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LinkedServiceProperties)jsonReader.readObject(reader -> {
            LinkedServiceProperties deserializedLinkedServiceProperties = new LinkedServiceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedLinkedServiceProperties.resourceId = reader.getString();
                    continue;
                }
                if ("writeAccessResourceId".equals(fieldName)) {
                    deserializedLinkedServiceProperties.writeAccessResourceId = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedLinkedServiceProperties.provisioningState = LinkedServiceEntityStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkedServiceProperties;
        });
    }
}

