/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.LinkedStorageAccountsProperties;
import com.azure.resourcemanager.loganalytics.models.DataSourceType;
import java.io.IOException;
import java.util.List;

public final class LinkedStorageAccountsResourceInner
extends ProxyResource {
    private LinkedStorageAccountsProperties innerProperties = new LinkedStorageAccountsProperties();
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(LinkedStorageAccountsResourceInner.class);

    private LinkedStorageAccountsProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DataSourceType dataSourceType() {
        return this.innerProperties() == null ? null : this.innerProperties().dataSourceType();
    }

    public List<String> storageAccountIds() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountIds();
    }

    public LinkedStorageAccountsResourceInner withStorageAccountIds(List<String> storageAccountIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LinkedStorageAccountsProperties();
        }
        this.innerProperties().withStorageAccountIds(storageAccountIds);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model LinkedStorageAccountsResourceInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static LinkedStorageAccountsResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (LinkedStorageAccountsResourceInner)((Object)jsonReader.readObject(reader -> {
            LinkedStorageAccountsResourceInner deserializedLinkedStorageAccountsResourceInner = new LinkedStorageAccountsResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLinkedStorageAccountsResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedLinkedStorageAccountsResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLinkedStorageAccountsResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedLinkedStorageAccountsResourceInner.innerProperties = LinkedStorageAccountsProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkedStorageAccountsResourceInner;
        }));
    }
}

