/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.LogAnalyticsQueryPackProperties;
import com.azure.resourcemanager.loganalytics.models.QueryPacksResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class LogAnalyticsQueryPackInner
extends QueryPacksResource {
    private LogAnalyticsQueryPackProperties innerProperties = new LogAnalyticsQueryPackProperties();
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(LogAnalyticsQueryPackInner.class);

    private LogAnalyticsQueryPackProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public LogAnalyticsQueryPackInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public LogAnalyticsQueryPackInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public String queryPackId() {
        return this.innerProperties() == null ? null : this.innerProperties().queryPackId();
    }

    public OffsetDateTime timeCreated() {
        return this.innerProperties() == null ? null : this.innerProperties().timeCreated();
    }

    public OffsetDateTime timeModified() {
        return this.innerProperties() == null ? null : this.innerProperties().timeModified();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    @Override
    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model LogAnalyticsQueryPackInner"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static LogAnalyticsQueryPackInner fromJson(JsonReader jsonReader) throws IOException {
        return (LogAnalyticsQueryPackInner)((Object)jsonReader.readObject(reader -> {
            LogAnalyticsQueryPackInner deserializedLogAnalyticsQueryPackInner = new LogAnalyticsQueryPackInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedLogAnalyticsQueryPackInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackInner.innerProperties = LogAnalyticsQueryPackProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogAnalyticsQueryPackInner;
        }));
    }
}

