/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPackQueryPropertiesRelated;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class LogAnalyticsQueryPackQueryProperties
implements JsonSerializable<LogAnalyticsQueryPackQueryProperties> {
    private String id;
    private String displayName;
    private OffsetDateTime timeCreated;
    private OffsetDateTime timeModified;
    private String author;
    private String description;
    private String body;
    private LogAnalyticsQueryPackQueryPropertiesRelated related;
    private Map<String, List<String>> tags;
    private Object properties;
    private static final ClientLogger LOGGER = new ClientLogger(LogAnalyticsQueryPackQueryProperties.class);

    public String id() {
        return this.id;
    }

    public String displayName() {
        return this.displayName;
    }

    public LogAnalyticsQueryPackQueryProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public OffsetDateTime timeModified() {
        return this.timeModified;
    }

    public String author() {
        return this.author;
    }

    public String description() {
        return this.description;
    }

    public LogAnalyticsQueryPackQueryProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String body() {
        return this.body;
    }

    public LogAnalyticsQueryPackQueryProperties withBody(String body) {
        this.body = body;
        return this;
    }

    public LogAnalyticsQueryPackQueryPropertiesRelated related() {
        return this.related;
    }

    public LogAnalyticsQueryPackQueryProperties withRelated(LogAnalyticsQueryPackQueryPropertiesRelated related) {
        this.related = related;
        return this;
    }

    public Map<String, List<String>> tags() {
        return this.tags;
    }

    public LogAnalyticsQueryPackQueryProperties withTags(Map<String, List<String>> tags) {
        this.tags = tags;
        return this;
    }

    public Object properties() {
        return this.properties;
    }

    public LogAnalyticsQueryPackQueryProperties withProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model LogAnalyticsQueryPackQueryProperties"));
        }
        if (this.body() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property body in model LogAnalyticsQueryPackQueryProperties"));
        }
        if (this.related() != null) {
            this.related().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("body", this.body);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("related", (JsonSerializable)this.related);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeString(element1)));
        jsonWriter.writeUntypedField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    public static LogAnalyticsQueryPackQueryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LogAnalyticsQueryPackQueryProperties)jsonReader.readObject(reader -> {
            LogAnalyticsQueryPackQueryProperties deserializedLogAnalyticsQueryPackQueryProperties = new LogAnalyticsQueryPackQueryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.displayName = reader.getString();
                    continue;
                }
                if ("body".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.body = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.id = reader.getString();
                    continue;
                }
                if ("timeCreated".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.timeCreated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("timeModified".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.timeModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("author".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.author = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.description = reader.getString();
                    continue;
                }
                if ("related".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.related = LogAnalyticsQueryPackQueryPropertiesRelated.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedLogAnalyticsQueryPackQueryProperties.tags = tags = reader.readMap(reader1 -> reader1.readArray(reader2 -> reader2.getString()));
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.properties = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogAnalyticsQueryPackQueryProperties;
        });
    }
}

