/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ManagementGroupProperties
implements JsonSerializable<ManagementGroupProperties> {
    private Integer serverCount;
    private Boolean isGateway;
    private String name;
    private String id;
    private OffsetDateTime created;
    private OffsetDateTime dataReceived;
    private String version;
    private String sku;

    public Integer serverCount() {
        return this.serverCount;
    }

    public ManagementGroupProperties withServerCount(Integer serverCount) {
        this.serverCount = serverCount;
        return this;
    }

    public Boolean isGateway() {
        return this.isGateway;
    }

    public ManagementGroupProperties withIsGateway(Boolean isGateway) {
        this.isGateway = isGateway;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ManagementGroupProperties withName(String name) {
        this.name = name;
        return this;
    }

    public String id() {
        return this.id;
    }

    public ManagementGroupProperties withId(String id) {
        this.id = id;
        return this;
    }

    public OffsetDateTime created() {
        return this.created;
    }

    public ManagementGroupProperties withCreated(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    public OffsetDateTime dataReceived() {
        return this.dataReceived;
    }

    public ManagementGroupProperties withDataReceived(OffsetDateTime dataReceived) {
        this.dataReceived = dataReceived;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ManagementGroupProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    public String sku() {
        return this.sku;
    }

    public ManagementGroupProperties withSku(String sku) {
        this.sku = sku;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("serverCount", (Number)this.serverCount);
        jsonWriter.writeBooleanField("isGateway", this.isGateway);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("created", this.created == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.created));
        jsonWriter.writeStringField("dataReceived", this.dataReceived == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.dataReceived));
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeStringField("sku", this.sku);
        return jsonWriter.writeEndObject();
    }

    public static ManagementGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagementGroupProperties)jsonReader.readObject(reader -> {
            ManagementGroupProperties deserializedManagementGroupProperties = new ManagementGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serverCount".equals(fieldName)) {
                    deserializedManagementGroupProperties.serverCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isGateway".equals(fieldName)) {
                    deserializedManagementGroupProperties.isGateway = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagementGroupProperties.name = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedManagementGroupProperties.id = reader.getString();
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedManagementGroupProperties.created = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("dataReceived".equals(fieldName)) {
                    deserializedManagementGroupProperties.dataReceived = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedManagementGroupProperties.version = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedManagementGroupProperties.sku = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagementGroupProperties;
        });
    }
}

