/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.SavedSearchProperties;
import com.azure.resourcemanager.loganalytics.models.Tag;
import java.io.IOException;
import java.util.List;

public final class SavedSearchInner
extends ProxyResource {
    private String etag;
    private SavedSearchProperties innerProperties = new SavedSearchProperties();
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(SavedSearchInner.class);

    public String etag() {
        return this.etag;
    }

    public SavedSearchInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    private SavedSearchProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String category() {
        return this.innerProperties() == null ? null : this.innerProperties().category();
    }

    public SavedSearchInner withCategory(String category) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SavedSearchProperties();
        }
        this.innerProperties().withCategory(category);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public SavedSearchInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SavedSearchProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public String query() {
        return this.innerProperties() == null ? null : this.innerProperties().query();
    }

    public SavedSearchInner withQuery(String query) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SavedSearchProperties();
        }
        this.innerProperties().withQuery(query);
        return this;
    }

    public String functionAlias() {
        return this.innerProperties() == null ? null : this.innerProperties().functionAlias();
    }

    public SavedSearchInner withFunctionAlias(String functionAlias) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SavedSearchProperties();
        }
        this.innerProperties().withFunctionAlias(functionAlias);
        return this;
    }

    public String functionParameters() {
        return this.innerProperties() == null ? null : this.innerProperties().functionParameters();
    }

    public SavedSearchInner withFunctionParameters(String functionParameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SavedSearchProperties();
        }
        this.innerProperties().withFunctionParameters(functionParameters);
        return this;
    }

    public Long version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public SavedSearchInner withVersion(Long version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SavedSearchProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public List<Tag> tags() {
        return this.innerProperties() == null ? null : this.innerProperties().tags();
    }

    public SavedSearchInner withTags(List<Tag> tags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SavedSearchProperties();
        }
        this.innerProperties().withTags(tags);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model SavedSearchInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("etag", this.etag);
        return jsonWriter.writeEndObject();
    }

    public static SavedSearchInner fromJson(JsonReader jsonReader) throws IOException {
        return (SavedSearchInner)((Object)jsonReader.readObject(reader -> {
            SavedSearchInner deserializedSavedSearchInner = new SavedSearchInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSavedSearchInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSavedSearchInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSavedSearchInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSavedSearchInner.innerProperties = SavedSearchProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedSavedSearchInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSavedSearchInner;
        }));
    }
}

