/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.Tag;
import java.io.IOException;
import java.util.List;

public final class SavedSearchProperties
implements JsonSerializable<SavedSearchProperties> {
    private String category;
    private String displayName;
    private String query;
    private String functionAlias;
    private String functionParameters;
    private Long version;
    private List<Tag> tags;
    private static final ClientLogger LOGGER = new ClientLogger(SavedSearchProperties.class);

    public String category() {
        return this.category;
    }

    public SavedSearchProperties withCategory(String category) {
        this.category = category;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public SavedSearchProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String query() {
        return this.query;
    }

    public SavedSearchProperties withQuery(String query) {
        this.query = query;
        return this;
    }

    public String functionAlias() {
        return this.functionAlias;
    }

    public SavedSearchProperties withFunctionAlias(String functionAlias) {
        this.functionAlias = functionAlias;
        return this;
    }

    public String functionParameters() {
        return this.functionParameters;
    }

    public SavedSearchProperties withFunctionParameters(String functionParameters) {
        this.functionParameters = functionParameters;
        return this;
    }

    public Long version() {
        return this.version;
    }

    public SavedSearchProperties withVersion(Long version) {
        this.version = version;
        return this;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public SavedSearchProperties withTags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.category() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property category in model SavedSearchProperties"));
        }
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model SavedSearchProperties"));
        }
        if (this.query() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property query in model SavedSearchProperties"));
        }
        if (this.tags() != null) {
            this.tags().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("query", this.query);
        jsonWriter.writeStringField("functionAlias", this.functionAlias);
        jsonWriter.writeStringField("functionParameters", this.functionParameters);
        jsonWriter.writeNumberField("version", (Number)this.version);
        jsonWriter.writeArrayField("tags", this.tags, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SavedSearchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SavedSearchProperties)jsonReader.readObject(reader -> {
            SavedSearchProperties deserializedSavedSearchProperties = new SavedSearchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("category".equals(fieldName)) {
                    deserializedSavedSearchProperties.category = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedSavedSearchProperties.displayName = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedSavedSearchProperties.query = reader.getString();
                    continue;
                }
                if ("functionAlias".equals(fieldName)) {
                    deserializedSavedSearchProperties.functionAlias = reader.getString();
                    continue;
                }
                if ("functionParameters".equals(fieldName)) {
                    deserializedSavedSearchProperties.functionParameters = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedSavedSearchProperties.version = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    List tags;
                    deserializedSavedSearchProperties.tags = tags = reader.readArray(reader1 -> Tag.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSavedSearchProperties;
        });
    }
}

