/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.StorageInsightProperties;
import com.azure.resourcemanager.loganalytics.models.StorageAccount;
import com.azure.resourcemanager.loganalytics.models.StorageInsightStatus;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class StorageInsightInner
extends ProxyResource {
    private StorageInsightProperties innerProperties;
    private String etag;
    private Map<String, String> tags;
    private String type;
    private String name;
    private String id;

    private StorageInsightProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public StorageInsightInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public StorageInsightInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public List<String> containers() {
        return this.innerProperties() == null ? null : this.innerProperties().containers();
    }

    public StorageInsightInner withContainers(List<String> containers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageInsightProperties();
        }
        this.innerProperties().withContainers(containers);
        return this;
    }

    public List<String> tables() {
        return this.innerProperties() == null ? null : this.innerProperties().tables();
    }

    public StorageInsightInner withTables(List<String> tables) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageInsightProperties();
        }
        this.innerProperties().withTables(tables);
        return this;
    }

    public StorageAccount storageAccount() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccount();
    }

    public StorageInsightInner withStorageAccount(StorageAccount storageAccount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageInsightProperties();
        }
        this.innerProperties().withStorageAccount(storageAccount);
        return this;
    }

    public StorageInsightStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("eTag", this.etag);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static StorageInsightInner fromJson(JsonReader jsonReader) throws IOException {
        return (StorageInsightInner)((Object)jsonReader.readObject(reader -> {
            StorageInsightInner deserializedStorageInsightInner = new StorageInsightInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedStorageInsightInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedStorageInsightInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStorageInsightInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStorageInsightInner.innerProperties = StorageInsightProperties.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedStorageInsightInner.etag = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedStorageInsightInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageInsightInner;
        }));
    }
}

