/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.StorageAccount;
import com.azure.resourcemanager.loganalytics.models.StorageInsightStatus;
import java.io.IOException;
import java.util.List;

public final class StorageInsightProperties
implements JsonSerializable<StorageInsightProperties> {
    private List<String> containers;
    private List<String> tables;
    private StorageAccount storageAccount;
    private StorageInsightStatus status;
    private static final ClientLogger LOGGER = new ClientLogger(StorageInsightProperties.class);

    public List<String> containers() {
        return this.containers;
    }

    public StorageInsightProperties withContainers(List<String> containers) {
        this.containers = containers;
        return this;
    }

    public List<String> tables() {
        return this.tables;
    }

    public StorageInsightProperties withTables(List<String> tables) {
        this.tables = tables;
        return this;
    }

    public StorageAccount storageAccount() {
        return this.storageAccount;
    }

    public StorageInsightProperties withStorageAccount(StorageAccount storageAccount) {
        this.storageAccount = storageAccount;
        return this;
    }

    public StorageInsightStatus status() {
        return this.status;
    }

    public void validate() {
        if (this.storageAccount() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageAccount in model StorageInsightProperties"));
        }
        this.storageAccount().validate();
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("storageAccount", (JsonSerializable)this.storageAccount);
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("tables", this.tables, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static StorageInsightProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StorageInsightProperties)jsonReader.readObject(reader -> {
            StorageInsightProperties deserializedStorageInsightProperties = new StorageInsightProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccount".equals(fieldName)) {
                    deserializedStorageInsightProperties.storageAccount = StorageAccount.fromJson(reader);
                    continue;
                }
                if ("containers".equals(fieldName)) {
                    List containers;
                    deserializedStorageInsightProperties.containers = containers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("tables".equals(fieldName)) {
                    List tables;
                    deserializedStorageInsightProperties.tables = tables = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedStorageInsightProperties.status = StorageInsightStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageInsightProperties;
        });
    }
}

