/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.TableProperties;
import com.azure.resourcemanager.loganalytics.models.ProvisioningStateEnum;
import com.azure.resourcemanager.loganalytics.models.RestoredLogs;
import com.azure.resourcemanager.loganalytics.models.ResultStatistics;
import com.azure.resourcemanager.loganalytics.models.Schema;
import com.azure.resourcemanager.loganalytics.models.SearchResults;
import com.azure.resourcemanager.loganalytics.models.SystemDataAutoGenerated;
import com.azure.resourcemanager.loganalytics.models.TablePlanEnum;
import java.io.IOException;

public final class TableInner
extends ProxyResource {
    private TableProperties innerProperties;
    private SystemDataAutoGenerated systemData;
    private String type;
    private String name;
    private String id;

    private TableProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemDataAutoGenerated systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public Integer retentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionInDays();
    }

    public TableInner withRetentionInDays(Integer retentionInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableProperties();
        }
        this.innerProperties().withRetentionInDays(retentionInDays);
        return this;
    }

    public Integer totalRetentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().totalRetentionInDays();
    }

    public TableInner withTotalRetentionInDays(Integer totalRetentionInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableProperties();
        }
        this.innerProperties().withTotalRetentionInDays(totalRetentionInDays);
        return this;
    }

    public Integer archiveRetentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().archiveRetentionInDays();
    }

    public SearchResults searchResults() {
        return this.innerProperties() == null ? null : this.innerProperties().searchResults();
    }

    public TableInner withSearchResults(SearchResults searchResults) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableProperties();
        }
        this.innerProperties().withSearchResults(searchResults);
        return this;
    }

    public RestoredLogs restoredLogs() {
        return this.innerProperties() == null ? null : this.innerProperties().restoredLogs();
    }

    public TableInner withRestoredLogs(RestoredLogs restoredLogs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableProperties();
        }
        this.innerProperties().withRestoredLogs(restoredLogs);
        return this;
    }

    public ResultStatistics resultStatistics() {
        return this.innerProperties() == null ? null : this.innerProperties().resultStatistics();
    }

    public TablePlanEnum plan() {
        return this.innerProperties() == null ? null : this.innerProperties().plan();
    }

    public TableInner withPlan(TablePlanEnum plan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableProperties();
        }
        this.innerProperties().withPlan(plan);
        return this;
    }

    public String lastPlanModifiedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().lastPlanModifiedDate();
    }

    public Schema schema() {
        return this.innerProperties() == null ? null : this.innerProperties().schema();
    }

    public TableInner withSchema(Schema schema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableProperties();
        }
        this.innerProperties().withSchema(schema);
        return this;
    }

    public ProvisioningStateEnum provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Boolean retentionInDaysAsDefault() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionInDaysAsDefault();
    }

    public Boolean totalRetentionInDaysAsDefault() {
        return this.innerProperties() == null ? null : this.innerProperties().totalRetentionInDaysAsDefault();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static TableInner fromJson(JsonReader jsonReader) throws IOException {
        return (TableInner)((Object)jsonReader.readObject(reader -> {
            TableInner deserializedTableInner = new TableInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTableInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTableInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTableInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTableInner.innerProperties = TableProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedTableInner.systemData = SystemDataAutoGenerated.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTableInner;
        }));
    }
}

