/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.ProvisioningStateEnum;
import com.azure.resourcemanager.loganalytics.models.RestoredLogs;
import com.azure.resourcemanager.loganalytics.models.ResultStatistics;
import com.azure.resourcemanager.loganalytics.models.Schema;
import com.azure.resourcemanager.loganalytics.models.SearchResults;
import com.azure.resourcemanager.loganalytics.models.TablePlanEnum;
import java.io.IOException;

public final class TableProperties
implements JsonSerializable<TableProperties> {
    private Integer retentionInDays;
    private Integer totalRetentionInDays;
    private Integer archiveRetentionInDays;
    private SearchResults searchResults;
    private RestoredLogs restoredLogs;
    private ResultStatistics resultStatistics;
    private TablePlanEnum plan;
    private String lastPlanModifiedDate;
    private Schema schema;
    private ProvisioningStateEnum provisioningState;
    private Boolean retentionInDaysAsDefault;
    private Boolean totalRetentionInDaysAsDefault;

    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    public TableProperties withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

    public Integer totalRetentionInDays() {
        return this.totalRetentionInDays;
    }

    public TableProperties withTotalRetentionInDays(Integer totalRetentionInDays) {
        this.totalRetentionInDays = totalRetentionInDays;
        return this;
    }

    public Integer archiveRetentionInDays() {
        return this.archiveRetentionInDays;
    }

    public SearchResults searchResults() {
        return this.searchResults;
    }

    public TableProperties withSearchResults(SearchResults searchResults) {
        this.searchResults = searchResults;
        return this;
    }

    public RestoredLogs restoredLogs() {
        return this.restoredLogs;
    }

    public TableProperties withRestoredLogs(RestoredLogs restoredLogs) {
        this.restoredLogs = restoredLogs;
        return this;
    }

    public ResultStatistics resultStatistics() {
        return this.resultStatistics;
    }

    public TablePlanEnum plan() {
        return this.plan;
    }

    public TableProperties withPlan(TablePlanEnum plan) {
        this.plan = plan;
        return this;
    }

    public String lastPlanModifiedDate() {
        return this.lastPlanModifiedDate;
    }

    public Schema schema() {
        return this.schema;
    }

    public TableProperties withSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public ProvisioningStateEnum provisioningState() {
        return this.provisioningState;
    }

    public Boolean retentionInDaysAsDefault() {
        return this.retentionInDaysAsDefault;
    }

    public Boolean totalRetentionInDaysAsDefault() {
        return this.totalRetentionInDaysAsDefault;
    }

    public void validate() {
        if (this.searchResults() != null) {
            this.searchResults().validate();
        }
        if (this.restoredLogs() != null) {
            this.restoredLogs().validate();
        }
        if (this.resultStatistics() != null) {
            this.resultStatistics().validate();
        }
        if (this.schema() != null) {
            this.schema().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("retentionInDays", (Number)this.retentionInDays);
        jsonWriter.writeNumberField("totalRetentionInDays", (Number)this.totalRetentionInDays);
        jsonWriter.writeJsonField("searchResults", (JsonSerializable)this.searchResults);
        jsonWriter.writeJsonField("restoredLogs", (JsonSerializable)this.restoredLogs);
        jsonWriter.writeStringField("plan", this.plan == null ? null : this.plan.toString());
        jsonWriter.writeJsonField("schema", (JsonSerializable)this.schema);
        return jsonWriter.writeEndObject();
    }

    public static TableProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TableProperties)jsonReader.readObject(reader -> {
            TableProperties deserializedTableProperties = new TableProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("retentionInDays".equals(fieldName)) {
                    deserializedTableProperties.retentionInDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("totalRetentionInDays".equals(fieldName)) {
                    deserializedTableProperties.totalRetentionInDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("archiveRetentionInDays".equals(fieldName)) {
                    deserializedTableProperties.archiveRetentionInDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("searchResults".equals(fieldName)) {
                    deserializedTableProperties.searchResults = SearchResults.fromJson(reader);
                    continue;
                }
                if ("restoredLogs".equals(fieldName)) {
                    deserializedTableProperties.restoredLogs = RestoredLogs.fromJson(reader);
                    continue;
                }
                if ("resultStatistics".equals(fieldName)) {
                    deserializedTableProperties.resultStatistics = ResultStatistics.fromJson(reader);
                    continue;
                }
                if ("plan".equals(fieldName)) {
                    deserializedTableProperties.plan = TablePlanEnum.fromString(reader.getString());
                    continue;
                }
                if ("lastPlanModifiedDate".equals(fieldName)) {
                    deserializedTableProperties.lastPlanModifiedDate = reader.getString();
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedTableProperties.schema = Schema.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedTableProperties.provisioningState = ProvisioningStateEnum.fromString(reader.getString());
                    continue;
                }
                if ("retentionInDaysAsDefault".equals(fieldName)) {
                    deserializedTableProperties.retentionInDaysAsDefault = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("totalRetentionInDaysAsDefault".equals(fieldName)) {
                    deserializedTableProperties.totalRetentionInDaysAsDefault = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTableProperties;
        });
    }
}

