/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.MetricName;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class UsageMetricInner
implements JsonSerializable<UsageMetricInner> {
    private MetricName name;
    private String unit;
    private Double currentValue;
    private Double limit;
    private OffsetDateTime nextResetTime;
    private String quotaPeriod;

    public MetricName name() {
        return this.name;
    }

    public UsageMetricInner withName(MetricName name) {
        this.name = name;
        return this;
    }

    public String unit() {
        return this.unit;
    }

    public UsageMetricInner withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public Double currentValue() {
        return this.currentValue;
    }

    public UsageMetricInner withCurrentValue(Double currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    public Double limit() {
        return this.limit;
    }

    public UsageMetricInner withLimit(Double limit) {
        this.limit = limit;
        return this;
    }

    public OffsetDateTime nextResetTime() {
        return this.nextResetTime;
    }

    public UsageMetricInner withNextResetTime(OffsetDateTime nextResetTime) {
        this.nextResetTime = nextResetTime;
        return this;
    }

    public String quotaPeriod() {
        return this.quotaPeriod;
    }

    public UsageMetricInner withQuotaPeriod(String quotaPeriod) {
        this.quotaPeriod = quotaPeriod;
        return this;
    }

    public void validate() {
        if (this.name() != null) {
            this.name().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("name", (JsonSerializable)this.name);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeNumberField("currentValue", (Number)this.currentValue);
        jsonWriter.writeNumberField("limit", (Number)this.limit);
        jsonWriter.writeStringField("nextResetTime", this.nextResetTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextResetTime));
        jsonWriter.writeStringField("quotaPeriod", this.quotaPeriod);
        return jsonWriter.writeEndObject();
    }

    public static UsageMetricInner fromJson(JsonReader jsonReader) throws IOException {
        return (UsageMetricInner)jsonReader.readObject(reader -> {
            UsageMetricInner deserializedUsageMetricInner = new UsageMetricInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedUsageMetricInner.name = MetricName.fromJson(reader);
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedUsageMetricInner.unit = reader.getString();
                    continue;
                }
                if ("currentValue".equals(fieldName)) {
                    deserializedUsageMetricInner.currentValue = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedUsageMetricInner.limit = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("nextResetTime".equals(fieldName)) {
                    deserializedUsageMetricInner.nextResetTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("quotaPeriod".equals(fieldName)) {
                    deserializedUsageMetricInner.quotaPeriod = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUsageMetricInner;
        });
    }
}

