/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.WorkspaceProperties;
import com.azure.resourcemanager.loganalytics.models.Identity;
import com.azure.resourcemanager.loganalytics.models.PrivateLinkScopedResource;
import com.azure.resourcemanager.loganalytics.models.PublicNetworkAccessType;
import com.azure.resourcemanager.loganalytics.models.SystemDataAutoGenerated;
import com.azure.resourcemanager.loganalytics.models.WorkspaceCapping;
import com.azure.resourcemanager.loganalytics.models.WorkspaceEntityStatus;
import com.azure.resourcemanager.loganalytics.models.WorkspaceFeatures;
import com.azure.resourcemanager.loganalytics.models.WorkspaceSku;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class WorkspaceInner
extends Resource {
    private WorkspaceProperties innerProperties;
    private Identity identity;
    private SystemDataAutoGenerated systemData;
    private String etag;
    private String type;
    private String name;
    private String id;

    private WorkspaceProperties innerProperties() {
        return this.innerProperties;
    }

    public Identity identity() {
        return this.identity;
    }

    public WorkspaceInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public SystemDataAutoGenerated systemData() {
        return this.systemData;
    }

    public String etag() {
        return this.etag;
    }

    public WorkspaceInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public WorkspaceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public WorkspaceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public WorkspaceEntityStatus provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String customerId() {
        return this.innerProperties() == null ? null : this.innerProperties().customerId();
    }

    public WorkspaceSku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public WorkspaceInner withSku(WorkspaceSku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public Integer retentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionInDays();
    }

    public WorkspaceInner withRetentionInDays(Integer retentionInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withRetentionInDays(retentionInDays);
        return this;
    }

    public WorkspaceCapping workspaceCapping() {
        return this.innerProperties() == null ? null : this.innerProperties().workspaceCapping();
    }

    public WorkspaceInner withWorkspaceCapping(WorkspaceCapping workspaceCapping) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withWorkspaceCapping(workspaceCapping);
        return this;
    }

    public String createdDate() {
        return this.innerProperties() == null ? null : this.innerProperties().createdDate();
    }

    public String modifiedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().modifiedDate();
    }

    public PublicNetworkAccessType publicNetworkAccessForIngestion() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccessForIngestion();
    }

    public WorkspaceInner withPublicNetworkAccessForIngestion(PublicNetworkAccessType publicNetworkAccessForIngestion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withPublicNetworkAccessForIngestion(publicNetworkAccessForIngestion);
        return this;
    }

    public PublicNetworkAccessType publicNetworkAccessForQuery() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccessForQuery();
    }

    public WorkspaceInner withPublicNetworkAccessForQuery(PublicNetworkAccessType publicNetworkAccessForQuery) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withPublicNetworkAccessForQuery(publicNetworkAccessForQuery);
        return this;
    }

    public Boolean forceCmkForQuery() {
        return this.innerProperties() == null ? null : this.innerProperties().forceCmkForQuery();
    }

    public WorkspaceInner withForceCmkForQuery(Boolean forceCmkForQuery) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withForceCmkForQuery(forceCmkForQuery);
        return this;
    }

    public List<PrivateLinkScopedResource> privateLinkScopedResources() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkScopedResources();
    }

    public WorkspaceFeatures features() {
        return this.innerProperties() == null ? null : this.innerProperties().features();
    }

    public WorkspaceInner withFeatures(WorkspaceFeatures features) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withFeatures(features);
        return this;
    }

    public String defaultDataCollectionRuleResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultDataCollectionRuleResourceId();
    }

    public WorkspaceInner withDefaultDataCollectionRuleResourceId(String defaultDataCollectionRuleResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withDefaultDataCollectionRuleResourceId(defaultDataCollectionRuleResourceId);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("etag", this.etag);
        return jsonWriter.writeEndObject();
    }

    public static WorkspaceInner fromJson(JsonReader jsonReader) throws IOException {
        return (WorkspaceInner)((Object)jsonReader.readObject(reader -> {
            WorkspaceInner deserializedWorkspaceInner = new WorkspaceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkspaceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkspaceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkspaceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedWorkspaceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedWorkspaceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkspaceInner.innerProperties = WorkspaceProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedWorkspaceInner.identity = Identity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedWorkspaceInner.systemData = SystemDataAutoGenerated.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedWorkspaceInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkspaceInner;
        }));
    }
}

