/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.PrivateLinkScopedResource;
import com.azure.resourcemanager.loganalytics.models.PublicNetworkAccessType;
import com.azure.resourcemanager.loganalytics.models.WorkspaceCapping;
import com.azure.resourcemanager.loganalytics.models.WorkspaceEntityStatus;
import com.azure.resourcemanager.loganalytics.models.WorkspaceFeatures;
import com.azure.resourcemanager.loganalytics.models.WorkspaceSku;
import java.io.IOException;
import java.util.List;

public final class WorkspaceProperties
implements JsonSerializable<WorkspaceProperties> {
    private WorkspaceEntityStatus provisioningState;
    private String customerId;
    private WorkspaceSku sku;
    private Integer retentionInDays;
    private WorkspaceCapping workspaceCapping;
    private String createdDate;
    private String modifiedDate;
    private PublicNetworkAccessType publicNetworkAccessForIngestion;
    private PublicNetworkAccessType publicNetworkAccessForQuery;
    private Boolean forceCmkForQuery;
    private List<PrivateLinkScopedResource> privateLinkScopedResources;
    private WorkspaceFeatures features;
    private String defaultDataCollectionRuleResourceId;

    public WorkspaceEntityStatus provisioningState() {
        return this.provisioningState;
    }

    public String customerId() {
        return this.customerId;
    }

    public WorkspaceSku sku() {
        return this.sku;
    }

    public WorkspaceProperties withSku(WorkspaceSku sku) {
        this.sku = sku;
        return this;
    }

    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    public WorkspaceProperties withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

    public WorkspaceCapping workspaceCapping() {
        return this.workspaceCapping;
    }

    public WorkspaceProperties withWorkspaceCapping(WorkspaceCapping workspaceCapping) {
        this.workspaceCapping = workspaceCapping;
        return this;
    }

    public String createdDate() {
        return this.createdDate;
    }

    public String modifiedDate() {
        return this.modifiedDate;
    }

    public PublicNetworkAccessType publicNetworkAccessForIngestion() {
        return this.publicNetworkAccessForIngestion;
    }

    public WorkspaceProperties withPublicNetworkAccessForIngestion(PublicNetworkAccessType publicNetworkAccessForIngestion) {
        this.publicNetworkAccessForIngestion = publicNetworkAccessForIngestion;
        return this;
    }

    public PublicNetworkAccessType publicNetworkAccessForQuery() {
        return this.publicNetworkAccessForQuery;
    }

    public WorkspaceProperties withPublicNetworkAccessForQuery(PublicNetworkAccessType publicNetworkAccessForQuery) {
        this.publicNetworkAccessForQuery = publicNetworkAccessForQuery;
        return this;
    }

    public Boolean forceCmkForQuery() {
        return this.forceCmkForQuery;
    }

    public WorkspaceProperties withForceCmkForQuery(Boolean forceCmkForQuery) {
        this.forceCmkForQuery = forceCmkForQuery;
        return this;
    }

    public List<PrivateLinkScopedResource> privateLinkScopedResources() {
        return this.privateLinkScopedResources;
    }

    public WorkspaceFeatures features() {
        return this.features;
    }

    public WorkspaceProperties withFeatures(WorkspaceFeatures features) {
        this.features = features;
        return this;
    }

    public String defaultDataCollectionRuleResourceId() {
        return this.defaultDataCollectionRuleResourceId;
    }

    public WorkspaceProperties withDefaultDataCollectionRuleResourceId(String defaultDataCollectionRuleResourceId) {
        this.defaultDataCollectionRuleResourceId = defaultDataCollectionRuleResourceId;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.workspaceCapping() != null) {
            this.workspaceCapping().validate();
        }
        if (this.privateLinkScopedResources() != null) {
            this.privateLinkScopedResources().forEach(e -> e.validate());
        }
        if (this.features() != null) {
            this.features().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeNumberField("retentionInDays", (Number)this.retentionInDays);
        jsonWriter.writeJsonField("workspaceCapping", (JsonSerializable)this.workspaceCapping);
        jsonWriter.writeStringField("publicNetworkAccessForIngestion", this.publicNetworkAccessForIngestion == null ? null : this.publicNetworkAccessForIngestion.toString());
        jsonWriter.writeStringField("publicNetworkAccessForQuery", this.publicNetworkAccessForQuery == null ? null : this.publicNetworkAccessForQuery.toString());
        jsonWriter.writeBooleanField("forceCmkForQuery", this.forceCmkForQuery);
        jsonWriter.writeJsonField("features", (JsonSerializable)this.features);
        jsonWriter.writeStringField("defaultDataCollectionRuleResourceId", this.defaultDataCollectionRuleResourceId);
        return jsonWriter.writeEndObject();
    }

    public static WorkspaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WorkspaceProperties)jsonReader.readObject(reader -> {
            WorkspaceProperties deserializedWorkspaceProperties = new WorkspaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedWorkspaceProperties.provisioningState = WorkspaceEntityStatus.fromString(reader.getString());
                    continue;
                }
                if ("customerId".equals(fieldName)) {
                    deserializedWorkspaceProperties.customerId = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedWorkspaceProperties.sku = WorkspaceSku.fromJson(reader);
                    continue;
                }
                if ("retentionInDays".equals(fieldName)) {
                    deserializedWorkspaceProperties.retentionInDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("workspaceCapping".equals(fieldName)) {
                    deserializedWorkspaceProperties.workspaceCapping = WorkspaceCapping.fromJson(reader);
                    continue;
                }
                if ("createdDate".equals(fieldName)) {
                    deserializedWorkspaceProperties.createdDate = reader.getString();
                    continue;
                }
                if ("modifiedDate".equals(fieldName)) {
                    deserializedWorkspaceProperties.modifiedDate = reader.getString();
                    continue;
                }
                if ("publicNetworkAccessForIngestion".equals(fieldName)) {
                    deserializedWorkspaceProperties.publicNetworkAccessForIngestion = PublicNetworkAccessType.fromString(reader.getString());
                    continue;
                }
                if ("publicNetworkAccessForQuery".equals(fieldName)) {
                    deserializedWorkspaceProperties.publicNetworkAccessForQuery = PublicNetworkAccessType.fromString(reader.getString());
                    continue;
                }
                if ("forceCmkForQuery".equals(fieldName)) {
                    deserializedWorkspaceProperties.forceCmkForQuery = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("privateLinkScopedResources".equals(fieldName)) {
                    List privateLinkScopedResources;
                    deserializedWorkspaceProperties.privateLinkScopedResources = privateLinkScopedResources = reader.readArray(reader1 -> PrivateLinkScopedResource.fromJson(reader1));
                    continue;
                }
                if ("features".equals(fieldName)) {
                    deserializedWorkspaceProperties.features = WorkspaceFeatures.fromJson(reader);
                    continue;
                }
                if ("defaultDataCollectionRuleResourceId".equals(fieldName)) {
                    deserializedWorkspaceProperties.defaultDataCollectionRuleResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkspaceProperties;
        });
    }
}

