/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.models.DataExportInner;
import com.azure.resourcemanager.loganalytics.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.loganalytics.models.DataExport;
import com.azure.resourcemanager.loganalytics.models.Type;
import java.util.Collections;
import java.util.List;

public final class DataExportImpl
implements DataExport,
DataExport.Definition,
DataExport.Update {
    private DataExportInner innerObject;
    private final LogAnalyticsManager serviceManager;
    private String resourceGroupName;
    private String workspaceName;
    private String dataExportName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String dataExportId() {
        return this.innerModel().dataExportId();
    }

    @Override
    public List<String> tableNames() {
        List<String> inner = this.innerModel().tableNames();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean enable() {
        return this.innerModel().enable();
    }

    @Override
    public String createdDate() {
        return this.innerModel().createdDate();
    }

    @Override
    public String lastModifiedDate() {
        return this.innerModel().lastModifiedDate();
    }

    @Override
    public String resourceId() {
        return this.innerModel().resourceId();
    }

    @Override
    public Type typePropertiesType() {
        return this.innerModel().typePropertiesType();
    }

    @Override
    public String eventHubName() {
        return this.innerModel().eventHubName();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DataExportInner innerModel() {
        return this.innerObject;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public DataExportImpl withExistingWorkspace(String resourceGroupName, String workspaceName) {
        this.resourceGroupName = resourceGroupName;
        this.workspaceName = workspaceName;
        return this;
    }

    @Override
    public DataExport create() {
        this.innerObject = (DataExportInner)((Object)this.serviceManager.serviceClient().getDataExports().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.dataExportName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DataExport create(Context context) {
        this.innerObject = (DataExportInner)((Object)this.serviceManager.serviceClient().getDataExports().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.dataExportName, this.innerModel(), context).getValue());
        return this;
    }

    DataExportImpl(String name, LogAnalyticsManager serviceManager) {
        this.innerObject = new DataExportInner();
        this.serviceManager = serviceManager;
        this.dataExportName = name;
    }

    @Override
    public DataExportImpl update() {
        return this;
    }

    @Override
    public DataExport apply() {
        this.innerObject = (DataExportInner)((Object)this.serviceManager.serviceClient().getDataExports().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.dataExportName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DataExport apply(Context context) {
        this.innerObject = (DataExportInner)((Object)this.serviceManager.serviceClient().getDataExports().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.dataExportName, this.innerModel(), context).getValue());
        return this;
    }

    DataExportImpl(DataExportInner innerObject, LogAnalyticsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourcegroups");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaces");
        this.dataExportName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dataExports");
    }

    @Override
    public DataExport refresh() {
        this.innerObject = (DataExportInner)((Object)this.serviceManager.serviceClient().getDataExports().getWithResponse(this.resourceGroupName, this.workspaceName, this.dataExportName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DataExport refresh(Context context) {
        this.innerObject = (DataExportInner)((Object)this.serviceManager.serviceClient().getDataExports().getWithResponse(this.resourceGroupName, this.workspaceName, this.dataExportName, context).getValue());
        return this;
    }

    @Override
    public DataExportImpl withDataExportId(String dataExportId) {
        this.innerModel().withDataExportId(dataExportId);
        return this;
    }

    @Override
    public DataExportImpl withTableNames(List<String> tableNames) {
        this.innerModel().withTableNames(tableNames);
        return this;
    }

    @Override
    public DataExportImpl withEnable(Boolean enable) {
        this.innerModel().withEnable(enable);
        return this;
    }

    @Override
    public DataExportImpl withCreatedDate(String createdDate) {
        this.innerModel().withCreatedDate(createdDate);
        return this;
    }

    @Override
    public DataExportImpl withLastModifiedDate(String lastModifiedDate) {
        this.innerModel().withLastModifiedDate(lastModifiedDate);
        return this;
    }

    @Override
    public DataExportImpl withResourceId(String resourceId) {
        this.innerModel().withResourceId(resourceId);
        return this;
    }

    @Override
    public DataExportImpl withEventHubName(String eventHubName) {
        this.innerModel().withEventHubName(eventHubName);
        return this;
    }
}

