/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.DataExportsClient;
import com.azure.resourcemanager.loganalytics.fluent.models.DataExportInner;
import com.azure.resourcemanager.loganalytics.implementation.DataExportImpl;
import com.azure.resourcemanager.loganalytics.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.loganalytics.models.DataExport;
import com.azure.resourcemanager.loganalytics.models.DataExports;

public final class DataExportsImpl
implements DataExports {
    private static final ClientLogger LOGGER = new ClientLogger(DataExportsImpl.class);
    private final DataExportsClient innerClient;
    private final LogAnalyticsManager serviceManager;

    public DataExportsImpl(DataExportsClient innerClient, LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DataExport> listByWorkspace(String resourceGroupName, String workspaceName) {
        PagedIterable<DataExportInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, workspaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DataExportImpl((DataExportInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DataExport> listByWorkspace(String resourceGroupName, String workspaceName, Context context) {
        PagedIterable<DataExportInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, workspaceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DataExportImpl((DataExportInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<DataExport> getWithResponse(String resourceGroupName, String workspaceName, String dataExportName, Context context) {
        Response<DataExportInner> inner = this.serviceClient().getWithResponse(resourceGroupName, workspaceName, dataExportName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DataExportImpl((DataExportInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DataExport get(String resourceGroupName, String workspaceName, String dataExportName) {
        DataExportInner inner = this.serviceClient().get(resourceGroupName, workspaceName, dataExportName);
        if (inner != null) {
            return new DataExportImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String workspaceName, String dataExportName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, workspaceName, dataExportName, context);
    }

    @Override
    public void delete(String resourceGroupName, String workspaceName, String dataExportName) {
        this.serviceClient().delete(resourceGroupName, workspaceName, dataExportName);
    }

    @Override
    public DataExport getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String dataExportName = ResourceManagerUtils.getValueFromIdByName(id, "dataExports");
        if (dataExportName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dataExports'.", id)));
        }
        return (DataExport)this.getWithResponse(resourceGroupName, workspaceName, dataExportName, Context.NONE).getValue();
    }

    @Override
    public Response<DataExport> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String dataExportName = ResourceManagerUtils.getValueFromIdByName(id, "dataExports");
        if (dataExportName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dataExports'.", id)));
        }
        return this.getWithResponse(resourceGroupName, workspaceName, dataExportName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String dataExportName = ResourceManagerUtils.getValueFromIdByName(id, "dataExports");
        if (dataExportName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dataExports'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, workspaceName, dataExportName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String dataExportName = ResourceManagerUtils.getValueFromIdByName(id, "dataExports");
        if (dataExportName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dataExports'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, workspaceName, dataExportName, context);
    }

    private DataExportsClient serviceClient() {
        return this.innerClient;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public DataExportImpl define(String name) {
        return new DataExportImpl(name, this.manager());
    }
}

