/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.models.LinkedStorageAccountsResourceInner;
import com.azure.resourcemanager.loganalytics.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.loganalytics.models.DataSourceType;
import com.azure.resourcemanager.loganalytics.models.LinkedStorageAccountsResource;
import java.util.Collections;
import java.util.List;

public final class LinkedStorageAccountsResourceImpl
implements LinkedStorageAccountsResource,
LinkedStorageAccountsResource.Definition,
LinkedStorageAccountsResource.Update {
    private LinkedStorageAccountsResourceInner innerObject;
    private final LogAnalyticsManager serviceManager;
    private String resourceGroupName;
    private String workspaceName;
    private DataSourceType dataSourceType;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public DataSourceType dataSourceType() {
        return this.innerModel().dataSourceType();
    }

    @Override
    public List<String> storageAccountIds() {
        List<String> inner = this.innerModel().storageAccountIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public LinkedStorageAccountsResourceInner innerModel() {
        return this.innerObject;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public LinkedStorageAccountsResourceImpl withExistingWorkspace(String resourceGroupName, String workspaceName) {
        this.resourceGroupName = resourceGroupName;
        this.workspaceName = workspaceName;
        return this;
    }

    @Override
    public LinkedStorageAccountsResource create() {
        this.innerObject = (LinkedStorageAccountsResourceInner)((Object)this.serviceManager.serviceClient().getLinkedStorageAccounts().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.dataSourceType, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public LinkedStorageAccountsResource create(Context context) {
        this.innerObject = (LinkedStorageAccountsResourceInner)((Object)this.serviceManager.serviceClient().getLinkedStorageAccounts().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.dataSourceType, this.innerModel(), context).getValue());
        return this;
    }

    LinkedStorageAccountsResourceImpl(DataSourceType name, LogAnalyticsManager serviceManager) {
        this.innerObject = new LinkedStorageAccountsResourceInner();
        this.serviceManager = serviceManager;
        this.dataSourceType = name;
    }

    @Override
    public LinkedStorageAccountsResourceImpl update() {
        return this;
    }

    @Override
    public LinkedStorageAccountsResource apply() {
        this.innerObject = (LinkedStorageAccountsResourceInner)((Object)this.serviceManager.serviceClient().getLinkedStorageAccounts().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.dataSourceType, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public LinkedStorageAccountsResource apply(Context context) {
        this.innerObject = (LinkedStorageAccountsResourceInner)((Object)this.serviceManager.serviceClient().getLinkedStorageAccounts().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.dataSourceType, this.innerModel(), context).getValue());
        return this;
    }

    LinkedStorageAccountsResourceImpl(LinkedStorageAccountsResourceInner innerObject, LogAnalyticsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourcegroups");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaces");
        this.dataSourceType = DataSourceType.fromString(ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "linkedStorageAccounts"));
    }

    @Override
    public LinkedStorageAccountsResource refresh() {
        this.innerObject = (LinkedStorageAccountsResourceInner)((Object)this.serviceManager.serviceClient().getLinkedStorageAccounts().getWithResponse(this.resourceGroupName, this.workspaceName, this.dataSourceType, Context.NONE).getValue());
        return this;
    }

    @Override
    public LinkedStorageAccountsResource refresh(Context context) {
        this.innerObject = (LinkedStorageAccountsResourceInner)((Object)this.serviceManager.serviceClient().getLinkedStorageAccounts().getWithResponse(this.resourceGroupName, this.workspaceName, this.dataSourceType, context).getValue());
        return this;
    }

    @Override
    public LinkedStorageAccountsResourceImpl withStorageAccountIds(List<String> storageAccountIds) {
        this.innerModel().withStorageAccountIds(storageAccountIds);
        return this;
    }
}

