/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.models.LogAnalyticsQueryPackInner;
import com.azure.resourcemanager.loganalytics.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPack;
import com.azure.resourcemanager.loganalytics.models.TagsResource;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class LogAnalyticsQueryPackImpl
implements LogAnalyticsQueryPack,
LogAnalyticsQueryPack.Definition,
LogAnalyticsQueryPack.Update {
    private LogAnalyticsQueryPackInner innerObject;
    private final LogAnalyticsManager serviceManager;
    private String resourceGroupName;
    private String queryPackName;
    private TagsResource updateQueryPackTags;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String queryPackId() {
        return this.innerModel().queryPackId();
    }

    @Override
    public OffsetDateTime timeCreated() {
        return this.innerModel().timeCreated();
    }

    @Override
    public OffsetDateTime timeModified() {
        return this.innerModel().timeModified();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public LogAnalyticsQueryPackInner innerModel() {
        return this.innerObject;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public LogAnalyticsQueryPackImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public LogAnalyticsQueryPack create() {
        this.innerObject = (LogAnalyticsQueryPackInner)((Object)this.serviceManager.serviceClient().getQueryPacks().createOrUpdateWithResponse(this.resourceGroupName, this.queryPackName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public LogAnalyticsQueryPack create(Context context) {
        this.innerObject = (LogAnalyticsQueryPackInner)((Object)this.serviceManager.serviceClient().getQueryPacks().createOrUpdateWithResponse(this.resourceGroupName, this.queryPackName, this.innerModel(), context).getValue());
        return this;
    }

    LogAnalyticsQueryPackImpl(String name, LogAnalyticsManager serviceManager) {
        this.innerObject = new LogAnalyticsQueryPackInner();
        this.serviceManager = serviceManager;
        this.queryPackName = name;
    }

    @Override
    public LogAnalyticsQueryPackImpl update() {
        this.updateQueryPackTags = new TagsResource();
        return this;
    }

    @Override
    public LogAnalyticsQueryPack apply() {
        this.innerObject = (LogAnalyticsQueryPackInner)((Object)this.serviceManager.serviceClient().getQueryPacks().updateTagsWithResponse(this.resourceGroupName, this.queryPackName, this.updateQueryPackTags, Context.NONE).getValue());
        return this;
    }

    @Override
    public LogAnalyticsQueryPack apply(Context context) {
        this.innerObject = (LogAnalyticsQueryPackInner)((Object)this.serviceManager.serviceClient().getQueryPacks().updateTagsWithResponse(this.resourceGroupName, this.queryPackName, this.updateQueryPackTags, context).getValue());
        return this;
    }

    LogAnalyticsQueryPackImpl(LogAnalyticsQueryPackInner innerObject, LogAnalyticsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.queryPackName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "queryPacks");
    }

    @Override
    public LogAnalyticsQueryPack refresh() {
        this.innerObject = (LogAnalyticsQueryPackInner)((Object)this.serviceManager.serviceClient().getQueryPacks().getByResourceGroupWithResponse(this.resourceGroupName, this.queryPackName, Context.NONE).getValue());
        return this;
    }

    @Override
    public LogAnalyticsQueryPack refresh(Context context) {
        this.innerObject = (LogAnalyticsQueryPackInner)((Object)this.serviceManager.serviceClient().getQueryPacks().getByResourceGroupWithResponse(this.resourceGroupName, this.queryPackName, context).getValue());
        return this;
    }

    @Override
    public LogAnalyticsQueryPackImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public LogAnalyticsQueryPackImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public LogAnalyticsQueryPackImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateQueryPackTags.withTags(tags);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

