/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.loganalytics.fluent.AvailableServiceTiersClient;
import com.azure.resourcemanager.loganalytics.fluent.ClustersClient;
import com.azure.resourcemanager.loganalytics.fluent.DataExportsClient;
import com.azure.resourcemanager.loganalytics.fluent.DataSourcesClient;
import com.azure.resourcemanager.loganalytics.fluent.DeletedWorkspacesClient;
import com.azure.resourcemanager.loganalytics.fluent.GatewaysClient;
import com.azure.resourcemanager.loganalytics.fluent.IntelligencePacksClient;
import com.azure.resourcemanager.loganalytics.fluent.LinkedServicesClient;
import com.azure.resourcemanager.loganalytics.fluent.LinkedStorageAccountsClient;
import com.azure.resourcemanager.loganalytics.fluent.ManagementGroupsClient;
import com.azure.resourcemanager.loganalytics.fluent.OperationStatusesClient;
import com.azure.resourcemanager.loganalytics.fluent.OperationalInsightsManagementClient;
import com.azure.resourcemanager.loganalytics.fluent.OperationsClient;
import com.azure.resourcemanager.loganalytics.fluent.QueriesClient;
import com.azure.resourcemanager.loganalytics.fluent.QueryPacksClient;
import com.azure.resourcemanager.loganalytics.fluent.SavedSearchesClient;
import com.azure.resourcemanager.loganalytics.fluent.SchemasClient;
import com.azure.resourcemanager.loganalytics.fluent.SharedKeysOperationsClient;
import com.azure.resourcemanager.loganalytics.fluent.StorageInsightConfigsClient;
import com.azure.resourcemanager.loganalytics.fluent.TablesClient;
import com.azure.resourcemanager.loganalytics.fluent.UsagesClient;
import com.azure.resourcemanager.loganalytics.fluent.WorkspacePurgesClient;
import com.azure.resourcemanager.loganalytics.fluent.WorkspacesClient;
import com.azure.resourcemanager.loganalytics.implementation.AvailableServiceTiersClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.ClustersClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.DataExportsClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.DataSourcesClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.DeletedWorkspacesClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.GatewaysClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.IntelligencePacksClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.LinkedServicesClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.LinkedStorageAccountsClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.ManagementGroupsClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.OperationStatusesClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.OperationalInsightsManagementClientBuilder;
import com.azure.resourcemanager.loganalytics.implementation.OperationsClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.QueriesClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.QueryPacksClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.SavedSearchesClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.SchemasClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.SharedKeysOperationsClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.StorageInsightConfigsClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.TablesClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.UsagesClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.WorkspacePurgesClientImpl;
import com.azure.resourcemanager.loganalytics.implementation.WorkspacesClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=OperationalInsightsManagementClientBuilder.class)
public final class OperationalInsightsManagementClientImpl
implements OperationalInsightsManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final QueryPacksClient queryPacks;
    private final QueriesClient queries;
    private final DataExportsClient dataExports;
    private final DataSourcesClient dataSources;
    private final IntelligencePacksClient intelligencePacks;
    private final LinkedServicesClient linkedServices;
    private final LinkedStorageAccountsClient linkedStorageAccounts;
    private final ManagementGroupsClient managementGroups;
    private final OperationStatusesClient operationStatuses;
    private final SharedKeysOperationsClient sharedKeysOperations;
    private final UsagesClient usages;
    private final StorageInsightConfigsClient storageInsightConfigs;
    private final SavedSearchesClient savedSearches;
    private final AvailableServiceTiersClient availableServiceTiers;
    private final GatewaysClient gateways;
    private final SchemasClient schemas;
    private final WorkspacePurgesClient workspacePurges;
    private final ClustersClient clusters;
    private final OperationsClient operations;
    private final WorkspacesClient workspaces;
    private final DeletedWorkspacesClient deletedWorkspaces;
    private final TablesClient tables;
    private static final ClientLogger LOGGER = new ClientLogger(OperationalInsightsManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public QueryPacksClient getQueryPacks() {
        return this.queryPacks;
    }

    @Override
    public QueriesClient getQueries() {
        return this.queries;
    }

    @Override
    public DataExportsClient getDataExports() {
        return this.dataExports;
    }

    @Override
    public DataSourcesClient getDataSources() {
        return this.dataSources;
    }

    @Override
    public IntelligencePacksClient getIntelligencePacks() {
        return this.intelligencePacks;
    }

    @Override
    public LinkedServicesClient getLinkedServices() {
        return this.linkedServices;
    }

    @Override
    public LinkedStorageAccountsClient getLinkedStorageAccounts() {
        return this.linkedStorageAccounts;
    }

    @Override
    public ManagementGroupsClient getManagementGroups() {
        return this.managementGroups;
    }

    @Override
    public OperationStatusesClient getOperationStatuses() {
        return this.operationStatuses;
    }

    @Override
    public SharedKeysOperationsClient getSharedKeysOperations() {
        return this.sharedKeysOperations;
    }

    @Override
    public UsagesClient getUsages() {
        return this.usages;
    }

    @Override
    public StorageInsightConfigsClient getStorageInsightConfigs() {
        return this.storageInsightConfigs;
    }

    @Override
    public SavedSearchesClient getSavedSearches() {
        return this.savedSearches;
    }

    @Override
    public AvailableServiceTiersClient getAvailableServiceTiers() {
        return this.availableServiceTiers;
    }

    @Override
    public GatewaysClient getGateways() {
        return this.gateways;
    }

    @Override
    public SchemasClient getSchemas() {
        return this.schemas;
    }

    @Override
    public WorkspacePurgesClient getWorkspacePurges() {
        return this.workspacePurges;
    }

    @Override
    public ClustersClient getClusters() {
        return this.clusters;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public WorkspacesClient getWorkspaces() {
        return this.workspaces;
    }

    @Override
    public DeletedWorkspacesClient getDeletedWorkspaces() {
        return this.deletedWorkspaces;
    }

    @Override
    public TablesClient getTables() {
        return this.tables;
    }

    OperationalInsightsManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.queryPacks = new QueryPacksClientImpl(this);
        this.queries = new QueriesClientImpl(this);
        this.dataExports = new DataExportsClientImpl(this);
        this.dataSources = new DataSourcesClientImpl(this);
        this.intelligencePacks = new IntelligencePacksClientImpl(this);
        this.linkedServices = new LinkedServicesClientImpl(this);
        this.linkedStorageAccounts = new LinkedStorageAccountsClientImpl(this);
        this.managementGroups = new ManagementGroupsClientImpl(this);
        this.operationStatuses = new OperationStatusesClientImpl(this);
        this.sharedKeysOperations = new SharedKeysOperationsClientImpl(this);
        this.usages = new UsagesClientImpl(this);
        this.storageInsightConfigs = new StorageInsightConfigsClientImpl(this);
        this.savedSearches = new SavedSearchesClientImpl(this);
        this.availableServiceTiers = new AvailableServiceTiersClientImpl(this);
        this.gateways = new GatewaysClientImpl(this);
        this.schemas = new SchemasClientImpl(this);
        this.workspacePurges = new WorkspacePurgesClientImpl(this);
        this.clusters = new ClustersClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.workspaces = new WorkspacesClientImpl(this);
        this.deletedWorkspaces = new DeletedWorkspacesClientImpl(this);
        this.tables = new TablesClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

