/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.models.StorageInsightInner;
import com.azure.resourcemanager.loganalytics.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.loganalytics.models.StorageAccount;
import com.azure.resourcemanager.loganalytics.models.StorageInsight;
import com.azure.resourcemanager.loganalytics.models.StorageInsightStatus;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class StorageInsightImpl
implements StorageInsight,
StorageInsight.Definition,
StorageInsight.Update {
    private StorageInsightInner innerObject;
    private final LogAnalyticsManager serviceManager;
    private String resourceGroupName;
    private String workspaceName;
    private String storageInsightName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public List<String> containers() {
        List<String> inner = this.innerModel().containers();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> tables() {
        List<String> inner = this.innerModel().tables();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public StorageAccount storageAccount() {
        return this.innerModel().storageAccount();
    }

    @Override
    public StorageInsightStatus status() {
        return this.innerModel().status();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public StorageInsightInner innerModel() {
        return this.innerObject;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public StorageInsightImpl withExistingWorkspace(String resourceGroupName, String workspaceName) {
        this.resourceGroupName = resourceGroupName;
        this.workspaceName = workspaceName;
        return this;
    }

    @Override
    public StorageInsight create() {
        this.innerObject = (StorageInsightInner)((Object)this.serviceManager.serviceClient().getStorageInsightConfigs().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.storageInsightName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public StorageInsight create(Context context) {
        this.innerObject = (StorageInsightInner)((Object)this.serviceManager.serviceClient().getStorageInsightConfigs().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.storageInsightName, this.innerModel(), context).getValue());
        return this;
    }

    StorageInsightImpl(String name, LogAnalyticsManager serviceManager) {
        this.innerObject = new StorageInsightInner();
        this.serviceManager = serviceManager;
        this.storageInsightName = name;
    }

    @Override
    public StorageInsightImpl update() {
        return this;
    }

    @Override
    public StorageInsight apply() {
        this.innerObject = (StorageInsightInner)((Object)this.serviceManager.serviceClient().getStorageInsightConfigs().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.storageInsightName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public StorageInsight apply(Context context) {
        this.innerObject = (StorageInsightInner)((Object)this.serviceManager.serviceClient().getStorageInsightConfigs().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.storageInsightName, this.innerModel(), context).getValue());
        return this;
    }

    StorageInsightImpl(StorageInsightInner innerObject, LogAnalyticsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourcegroups");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaces");
        this.storageInsightName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "storageInsightConfigs");
    }

    @Override
    public StorageInsight refresh() {
        this.innerObject = (StorageInsightInner)((Object)this.serviceManager.serviceClient().getStorageInsightConfigs().getWithResponse(this.resourceGroupName, this.workspaceName, this.storageInsightName, Context.NONE).getValue());
        return this;
    }

    @Override
    public StorageInsight refresh(Context context) {
        this.innerObject = (StorageInsightInner)((Object)this.serviceManager.serviceClient().getStorageInsightConfigs().getWithResponse(this.resourceGroupName, this.workspaceName, this.storageInsightName, context).getValue());
        return this;
    }

    @Override
    public StorageInsightImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags(tags);
        return this;
    }

    @Override
    public StorageInsightImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public StorageInsightImpl withContainers(List<String> containers) {
        this.innerModel().withContainers(containers);
        return this;
    }

    @Override
    public StorageInsightImpl withTables(List<String> tables) {
        this.innerModel().withTables(tables);
        return this;
    }

    @Override
    public StorageInsightImpl withStorageAccount(StorageAccount storageAccount) {
        this.innerModel().withStorageAccount(storageAccount);
        return this;
    }
}

