/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.models.TableInner;
import com.azure.resourcemanager.loganalytics.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.loganalytics.models.ProvisioningStateEnum;
import com.azure.resourcemanager.loganalytics.models.RestoredLogs;
import com.azure.resourcemanager.loganalytics.models.ResultStatistics;
import com.azure.resourcemanager.loganalytics.models.Schema;
import com.azure.resourcemanager.loganalytics.models.SearchResults;
import com.azure.resourcemanager.loganalytics.models.SystemDataAutoGenerated;
import com.azure.resourcemanager.loganalytics.models.Table;
import com.azure.resourcemanager.loganalytics.models.TablePlanEnum;

public final class TableImpl
implements Table,
Table.Definition,
Table.Update {
    private TableInner innerObject;
    private final LogAnalyticsManager serviceManager;
    private String resourceGroupName;
    private String workspaceName;
    private String tableName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemDataAutoGenerated systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Integer retentionInDays() {
        return this.innerModel().retentionInDays();
    }

    @Override
    public Integer totalRetentionInDays() {
        return this.innerModel().totalRetentionInDays();
    }

    @Override
    public Integer archiveRetentionInDays() {
        return this.innerModel().archiveRetentionInDays();
    }

    @Override
    public SearchResults searchResults() {
        return this.innerModel().searchResults();
    }

    @Override
    public RestoredLogs restoredLogs() {
        return this.innerModel().restoredLogs();
    }

    @Override
    public ResultStatistics resultStatistics() {
        return this.innerModel().resultStatistics();
    }

    @Override
    public TablePlanEnum plan() {
        return this.innerModel().plan();
    }

    @Override
    public String lastPlanModifiedDate() {
        return this.innerModel().lastPlanModifiedDate();
    }

    @Override
    public Schema schema() {
        return this.innerModel().schema();
    }

    @Override
    public ProvisioningStateEnum provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Boolean retentionInDaysAsDefault() {
        return this.innerModel().retentionInDaysAsDefault();
    }

    @Override
    public Boolean totalRetentionInDaysAsDefault() {
        return this.innerModel().totalRetentionInDaysAsDefault();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public TableInner innerModel() {
        return this.innerObject;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public TableImpl withExistingWorkspace(String resourceGroupName, String workspaceName) {
        this.resourceGroupName = resourceGroupName;
        this.workspaceName = workspaceName;
        return this;
    }

    @Override
    public Table create() {
        this.innerObject = this.serviceManager.serviceClient().getTables().createOrUpdate(this.resourceGroupName, this.workspaceName, this.tableName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Table create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTables().createOrUpdate(this.resourceGroupName, this.workspaceName, this.tableName, this.innerModel(), context);
        return this;
    }

    TableImpl(String name, LogAnalyticsManager serviceManager) {
        this.innerObject = new TableInner();
        this.serviceManager = serviceManager;
        this.tableName = name;
    }

    @Override
    public TableImpl update() {
        return this;
    }

    @Override
    public Table apply() {
        this.innerObject = this.serviceManager.serviceClient().getTables().update(this.resourceGroupName, this.workspaceName, this.tableName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Table apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTables().update(this.resourceGroupName, this.workspaceName, this.tableName, this.innerModel(), context);
        return this;
    }

    TableImpl(TableInner innerObject, LogAnalyticsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaces");
        this.tableName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "tables");
    }

    @Override
    public Table refresh() {
        this.innerObject = (TableInner)((Object)this.serviceManager.serviceClient().getTables().getWithResponse(this.resourceGroupName, this.workspaceName, this.tableName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Table refresh(Context context) {
        this.innerObject = (TableInner)((Object)this.serviceManager.serviceClient().getTables().getWithResponse(this.resourceGroupName, this.workspaceName, this.tableName, context).getValue());
        return this;
    }

    @Override
    public Response<Void> migrateWithResponse(Context context) {
        return this.serviceManager.tables().migrateWithResponse(this.resourceGroupName, this.workspaceName, this.tableName, context);
    }

    @Override
    public void migrate() {
        this.serviceManager.tables().migrate(this.resourceGroupName, this.workspaceName, this.tableName);
    }

    @Override
    public Response<Void> cancelSearchWithResponse(Context context) {
        return this.serviceManager.tables().cancelSearchWithResponse(this.resourceGroupName, this.workspaceName, this.tableName, context);
    }

    @Override
    public void cancelSearch() {
        this.serviceManager.tables().cancelSearch(this.resourceGroupName, this.workspaceName, this.tableName);
    }

    @Override
    public TableImpl withRetentionInDays(Integer retentionInDays) {
        this.innerModel().withRetentionInDays(retentionInDays);
        return this;
    }

    @Override
    public TableImpl withTotalRetentionInDays(Integer totalRetentionInDays) {
        this.innerModel().withTotalRetentionInDays(totalRetentionInDays);
        return this;
    }

    @Override
    public TableImpl withSearchResults(SearchResults searchResults) {
        this.innerModel().withSearchResults(searchResults);
        return this;
    }

    @Override
    public TableImpl withRestoredLogs(RestoredLogs restoredLogs) {
        this.innerModel().withRestoredLogs(restoredLogs);
        return this;
    }

    @Override
    public TableImpl withPlan(TablePlanEnum plan) {
        this.innerModel().withPlan(plan);
        return this;
    }

    @Override
    public TableImpl withSchema(Schema schema) {
        this.innerModel().withSchema(schema);
        return this;
    }
}

