/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.WorkspacePurgesClient;
import com.azure.resourcemanager.loganalytics.fluent.models.WorkspacePurgeResponseInner;
import com.azure.resourcemanager.loganalytics.fluent.models.WorkspacePurgeStatusResponseInner;
import com.azure.resourcemanager.loganalytics.implementation.WorkspacePurgeResponseImpl;
import com.azure.resourcemanager.loganalytics.implementation.WorkspacePurgeStatusResponseImpl;
import com.azure.resourcemanager.loganalytics.models.WorkspacePurgeBody;
import com.azure.resourcemanager.loganalytics.models.WorkspacePurgeResponse;
import com.azure.resourcemanager.loganalytics.models.WorkspacePurgeStatusResponse;
import com.azure.resourcemanager.loganalytics.models.WorkspacePurges;
import com.azure.resourcemanager.loganalytics.models.WorkspacePurgesPurgeResponse;

public final class WorkspacePurgesImpl
implements WorkspacePurges {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspacePurgesImpl.class);
    private final WorkspacePurgesClient innerClient;
    private final LogAnalyticsManager serviceManager;

    public WorkspacePurgesImpl(WorkspacePurgesClient innerClient, LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<WorkspacePurgeResponse> purgeWithResponse(String resourceGroupName, String workspaceName, WorkspacePurgeBody body, Context context) {
        WorkspacePurgesPurgeResponse inner = this.serviceClient().purgeWithResponse(resourceGroupName, workspaceName, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WorkspacePurgeResponseImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public WorkspacePurgeResponse purge(String resourceGroupName, String workspaceName, WorkspacePurgeBody body) {
        WorkspacePurgeResponseInner inner = this.serviceClient().purge(resourceGroupName, workspaceName, body);
        if (inner != null) {
            return new WorkspacePurgeResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<WorkspacePurgeStatusResponse> getPurgeStatusWithResponse(String resourceGroupName, String workspaceName, String purgeId, Context context) {
        Response<WorkspacePurgeStatusResponseInner> inner = this.serviceClient().getPurgeStatusWithResponse(resourceGroupName, workspaceName, purgeId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WorkspacePurgeStatusResponseImpl((WorkspacePurgeStatusResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public WorkspacePurgeStatusResponse getPurgeStatus(String resourceGroupName, String workspaceName, String purgeId) {
        WorkspacePurgeStatusResponseInner inner = this.serviceClient().getPurgeStatus(resourceGroupName, workspaceName, purgeId);
        if (inner != null) {
            return new WorkspacePurgeStatusResponseImpl(inner, this.manager());
        }
        return null;
    }

    private WorkspacePurgesClient serviceClient() {
        return this.innerClient;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }
}

