/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.ClusterInner;
import java.io.IOException;
import java.util.List;

public final class ClusterListResult
implements JsonSerializable<ClusterListResult> {
    private String nextLink;
    private List<ClusterInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public ClusterListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<ClusterInner> value() {
        return this.value;
    }

    public ClusterListResult withValue(List<ClusterInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ClusterListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterListResult)jsonReader.readObject(reader -> {
            ClusterListResult deserializedClusterListResult = new ClusterListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedClusterListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedClusterListResult.value = value = reader.readArray(reader1 -> ClusterInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterListResult;
        });
    }
}

