/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.Capacity;
import com.azure.resourcemanager.loganalytics.models.ClusterSkuNameEnum;
import java.io.IOException;

public final class ClusterSku
implements JsonSerializable<ClusterSku> {
    private Capacity capacity;
    private ClusterSkuNameEnum name;

    public Capacity capacity() {
        return this.capacity;
    }

    public ClusterSku withCapacity(Capacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public ClusterSkuNameEnum name() {
        return this.name;
    }

    public ClusterSku withName(ClusterSkuNameEnum name) {
        this.name = name;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("capacity", this.capacity == null ? null : Long.valueOf(this.capacity.toLong()));
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static ClusterSku fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterSku)jsonReader.readObject(reader -> {
            ClusterSku deserializedClusterSku = new ClusterSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("capacity".equals(fieldName)) {
                    deserializedClusterSku.capacity = Capacity.fromLong(reader.getLong());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedClusterSku.name = ClusterSkuNameEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterSku;
        });
    }
}

