/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.ColumnDataTypeHintEnum;
import com.azure.resourcemanager.loganalytics.models.ColumnTypeEnum;
import java.io.IOException;

public final class Column
implements JsonSerializable<Column> {
    private String name;
    private ColumnTypeEnum type;
    private ColumnDataTypeHintEnum dataTypeHint;
    private String displayName;
    private String description;
    private Boolean isDefaultDisplay;
    private Boolean isHidden;

    public String name() {
        return this.name;
    }

    public Column withName(String name) {
        this.name = name;
        return this;
    }

    public ColumnTypeEnum type() {
        return this.type;
    }

    public Column withType(ColumnTypeEnum type) {
        this.type = type;
        return this;
    }

    public ColumnDataTypeHintEnum dataTypeHint() {
        return this.dataTypeHint;
    }

    public Column withDataTypeHint(ColumnDataTypeHintEnum dataTypeHint) {
        this.dataTypeHint = dataTypeHint;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public Column withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Column withDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean isDefaultDisplay() {
        return this.isDefaultDisplay;
    }

    public Boolean isHidden() {
        return this.isHidden;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("dataTypeHint", this.dataTypeHint == null ? null : this.dataTypeHint.toString());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static Column fromJson(JsonReader jsonReader) throws IOException {
        return (Column)jsonReader.readObject(reader -> {
            Column deserializedColumn = new Column();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedColumn.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedColumn.type = ColumnTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("dataTypeHint".equals(fieldName)) {
                    deserializedColumn.dataTypeHint = ColumnDataTypeHintEnum.fromString(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedColumn.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedColumn.description = reader.getString();
                    continue;
                }
                if ("isDefaultDisplay".equals(fieldName)) {
                    deserializedColumn.isDefaultDisplay = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isHidden".equals(fieldName)) {
                    deserializedColumn.isHidden = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedColumn;
        });
    }
}

