/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.DataSourceInner;
import java.io.IOException;
import java.util.List;

public final class DataSourceListResult
implements JsonSerializable<DataSourceListResult> {
    private List<DataSourceInner> value;
    private String nextLink;

    public List<DataSourceInner> value() {
        return this.value;
    }

    public DataSourceListResult withValue(List<DataSourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public DataSourceListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static DataSourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (DataSourceListResult)jsonReader.readObject(reader -> {
            DataSourceListResult deserializedDataSourceListResult = new DataSourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDataSourceListResult.value = value = reader.readArray(reader1 -> DataSourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDataSourceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataSourceListResult;
        });
    }
}

