/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.LogAnalyticsQueryPackInner;
import java.io.IOException;
import java.util.List;

public final class LogAnalyticsQueryPackListResult
implements JsonSerializable<LogAnalyticsQueryPackListResult> {
    private List<LogAnalyticsQueryPackInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(LogAnalyticsQueryPackListResult.class);

    public List<LogAnalyticsQueryPackInner> value() {
        return this.value;
    }

    public LogAnalyticsQueryPackListResult withValue(List<LogAnalyticsQueryPackInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public LogAnalyticsQueryPackListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model LogAnalyticsQueryPackListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static LogAnalyticsQueryPackListResult fromJson(JsonReader jsonReader) throws IOException {
        return (LogAnalyticsQueryPackListResult)jsonReader.readObject(reader -> {
            LogAnalyticsQueryPackListResult deserializedLogAnalyticsQueryPackListResult = new LogAnalyticsQueryPackListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedLogAnalyticsQueryPackListResult.value = value = reader.readArray(reader1 -> LogAnalyticsQueryPackInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogAnalyticsQueryPackListResult;
        });
    }
}

