/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class RestoredLogs
implements JsonSerializable<RestoredLogs> {
    private OffsetDateTime startRestoreTime;
    private OffsetDateTime endRestoreTime;
    private String sourceTable;
    private String azureAsyncOperationId;

    public OffsetDateTime startRestoreTime() {
        return this.startRestoreTime;
    }

    public RestoredLogs withStartRestoreTime(OffsetDateTime startRestoreTime) {
        this.startRestoreTime = startRestoreTime;
        return this;
    }

    public OffsetDateTime endRestoreTime() {
        return this.endRestoreTime;
    }

    public RestoredLogs withEndRestoreTime(OffsetDateTime endRestoreTime) {
        this.endRestoreTime = endRestoreTime;
        return this;
    }

    public String sourceTable() {
        return this.sourceTable;
    }

    public RestoredLogs withSourceTable(String sourceTable) {
        this.sourceTable = sourceTable;
        return this;
    }

    public String azureAsyncOperationId() {
        return this.azureAsyncOperationId;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startRestoreTime", this.startRestoreTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startRestoreTime));
        jsonWriter.writeStringField("endRestoreTime", this.endRestoreTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endRestoreTime));
        jsonWriter.writeStringField("sourceTable", this.sourceTable);
        return jsonWriter.writeEndObject();
    }

    public static RestoredLogs fromJson(JsonReader jsonReader) throws IOException {
        return (RestoredLogs)jsonReader.readObject(reader -> {
            RestoredLogs deserializedRestoredLogs = new RestoredLogs();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startRestoreTime".equals(fieldName)) {
                    deserializedRestoredLogs.startRestoreTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endRestoreTime".equals(fieldName)) {
                    deserializedRestoredLogs.endRestoreTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("sourceTable".equals(fieldName)) {
                    deserializedRestoredLogs.sourceTable = reader.getString();
                    continue;
                }
                if ("azureAsyncOperationId".equals(fieldName)) {
                    deserializedRestoredLogs.azureAsyncOperationId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestoredLogs;
        });
    }
}

