/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.Column;
import com.azure.resourcemanager.loganalytics.models.SourceEnum;
import com.azure.resourcemanager.loganalytics.models.TableSubTypeEnum;
import com.azure.resourcemanager.loganalytics.models.TableTypeEnum;
import java.io.IOException;
import java.util.List;

public final class Schema
implements JsonSerializable<Schema> {
    private String name;
    private String displayName;
    private String description;
    private List<Column> columns;
    private List<Column> standardColumns;
    private List<String> categories;
    private List<String> labels;
    private SourceEnum source;
    private TableTypeEnum tableType;
    private TableSubTypeEnum tableSubType;
    private List<String> solutions;

    public String name() {
        return this.name;
    }

    public Schema withName(String name) {
        this.name = name;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public Schema withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Schema withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<Column> columns() {
        return this.columns;
    }

    public Schema withColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public List<Column> standardColumns() {
        return this.standardColumns;
    }

    public List<String> categories() {
        return this.categories;
    }

    public List<String> labels() {
        return this.labels;
    }

    public SourceEnum source() {
        return this.source;
    }

    public TableTypeEnum tableType() {
        return this.tableType;
    }

    public TableSubTypeEnum tableSubType() {
        return this.tableSubType;
    }

    public List<String> solutions() {
        return this.solutions;
    }

    public void validate() {
        if (this.columns() != null) {
            this.columns().forEach(e -> e.validate());
        }
        if (this.standardColumns() != null) {
            this.standardColumns().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static Schema fromJson(JsonReader jsonReader) throws IOException {
        return (Schema)jsonReader.readObject(reader -> {
            Schema deserializedSchema = new Schema();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSchema.name = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedSchema.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSchema.description = reader.getString();
                    continue;
                }
                if ("columns".equals(fieldName)) {
                    List columns;
                    deserializedSchema.columns = columns = reader.readArray(reader1 -> Column.fromJson(reader1));
                    continue;
                }
                if ("standardColumns".equals(fieldName)) {
                    List standardColumns;
                    deserializedSchema.standardColumns = standardColumns = reader.readArray(reader1 -> Column.fromJson(reader1));
                    continue;
                }
                if ("categories".equals(fieldName)) {
                    List categories;
                    deserializedSchema.categories = categories = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    List labels;
                    deserializedSchema.labels = labels = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedSchema.source = SourceEnum.fromString(reader.getString());
                    continue;
                }
                if ("tableType".equals(fieldName)) {
                    deserializedSchema.tableType = TableTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("tableSubType".equals(fieldName)) {
                    deserializedSchema.tableSubType = TableSubTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("solutions".equals(fieldName)) {
                    List solutions;
                    deserializedSchema.solutions = solutions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSchema;
        });
    }
}

