/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.CoreSummary;
import com.azure.resourcemanager.loganalytics.models.SearchMetadataSchema;
import com.azure.resourcemanager.loganalytics.models.SearchSort;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class SearchMetadata
implements JsonSerializable<SearchMetadata> {
    private String searchId;
    private String resultType;
    private Long total;
    private Long top;
    private String id;
    private List<CoreSummary> coreSummaries;
    private String status;
    private OffsetDateTime startTime;
    private OffsetDateTime lastUpdated;
    private String etag;
    private List<SearchSort> sort;
    private Long requestTime;
    private String aggregatedValueField;
    private String aggregatedGroupingFields;
    private Long sum;
    private Long max;
    private SearchMetadataSchema schema;

    public String searchId() {
        return this.searchId;
    }

    public SearchMetadata withSearchId(String searchId) {
        this.searchId = searchId;
        return this;
    }

    public String resultType() {
        return this.resultType;
    }

    public SearchMetadata withResultType(String resultType) {
        this.resultType = resultType;
        return this;
    }

    public Long total() {
        return this.total;
    }

    public SearchMetadata withTotal(Long total) {
        this.total = total;
        return this;
    }

    public Long top() {
        return this.top;
    }

    public SearchMetadata withTop(Long top) {
        this.top = top;
        return this;
    }

    public String id() {
        return this.id;
    }

    public SearchMetadata withId(String id) {
        this.id = id;
        return this;
    }

    public List<CoreSummary> coreSummaries() {
        return this.coreSummaries;
    }

    public SearchMetadata withCoreSummaries(List<CoreSummary> coreSummaries) {
        this.coreSummaries = coreSummaries;
        return this;
    }

    public String status() {
        return this.status;
    }

    public SearchMetadata withStatus(String status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public SearchMetadata withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime lastUpdated() {
        return this.lastUpdated;
    }

    public SearchMetadata withLastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public SearchMetadata withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public List<SearchSort> sort() {
        return this.sort;
    }

    public SearchMetadata withSort(List<SearchSort> sort) {
        this.sort = sort;
        return this;
    }

    public Long requestTime() {
        return this.requestTime;
    }

    public SearchMetadata withRequestTime(Long requestTime) {
        this.requestTime = requestTime;
        return this;
    }

    public String aggregatedValueField() {
        return this.aggregatedValueField;
    }

    public SearchMetadata withAggregatedValueField(String aggregatedValueField) {
        this.aggregatedValueField = aggregatedValueField;
        return this;
    }

    public String aggregatedGroupingFields() {
        return this.aggregatedGroupingFields;
    }

    public SearchMetadata withAggregatedGroupingFields(String aggregatedGroupingFields) {
        this.aggregatedGroupingFields = aggregatedGroupingFields;
        return this;
    }

    public Long sum() {
        return this.sum;
    }

    public SearchMetadata withSum(Long sum) {
        this.sum = sum;
        return this;
    }

    public Long max() {
        return this.max;
    }

    public SearchMetadata withMax(Long max) {
        this.max = max;
        return this;
    }

    public SearchMetadataSchema schema() {
        return this.schema;
    }

    public SearchMetadata withSchema(SearchMetadataSchema schema) {
        this.schema = schema;
        return this;
    }

    public void validate() {
        if (this.coreSummaries() != null) {
            this.coreSummaries().forEach(e -> e.validate());
        }
        if (this.sort() != null) {
            this.sort().forEach(e -> e.validate());
        }
        if (this.schema() != null) {
            this.schema().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("requestId", this.searchId);
        jsonWriter.writeStringField("resultType", this.resultType);
        jsonWriter.writeNumberField("total", (Number)this.total);
        jsonWriter.writeNumberField("top", (Number)this.top);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeArrayField("coreSummaries", this.coreSummaries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("lastUpdated", this.lastUpdated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdated));
        jsonWriter.writeStringField("eTag", this.etag);
        jsonWriter.writeArrayField("sort", this.sort, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("requestTime", (Number)this.requestTime);
        jsonWriter.writeStringField("aggregatedValueField", this.aggregatedValueField);
        jsonWriter.writeStringField("aggregatedGroupingFields", this.aggregatedGroupingFields);
        jsonWriter.writeNumberField("sum", (Number)this.sum);
        jsonWriter.writeNumberField("max", (Number)this.max);
        jsonWriter.writeJsonField("schema", (JsonSerializable)this.schema);
        return jsonWriter.writeEndObject();
    }

    public static SearchMetadata fromJson(JsonReader jsonReader) throws IOException {
        return (SearchMetadata)jsonReader.readObject(reader -> {
            SearchMetadata deserializedSearchMetadata = new SearchMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("requestId".equals(fieldName)) {
                    deserializedSearchMetadata.searchId = reader.getString();
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedSearchMetadata.resultType = reader.getString();
                    continue;
                }
                if ("total".equals(fieldName)) {
                    deserializedSearchMetadata.total = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("top".equals(fieldName)) {
                    deserializedSearchMetadata.top = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedSearchMetadata.id = reader.getString();
                    continue;
                }
                if ("coreSummaries".equals(fieldName)) {
                    List coreSummaries;
                    deserializedSearchMetadata.coreSummaries = coreSummaries = reader.readArray(reader1 -> CoreSummary.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSearchMetadata.status = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedSearchMetadata.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdated".equals(fieldName)) {
                    deserializedSearchMetadata.lastUpdated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedSearchMetadata.etag = reader.getString();
                    continue;
                }
                if ("sort".equals(fieldName)) {
                    List sort;
                    deserializedSearchMetadata.sort = sort = reader.readArray(reader1 -> SearchSort.fromJson(reader1));
                    continue;
                }
                if ("requestTime".equals(fieldName)) {
                    deserializedSearchMetadata.requestTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("aggregatedValueField".equals(fieldName)) {
                    deserializedSearchMetadata.aggregatedValueField = reader.getString();
                    continue;
                }
                if ("aggregatedGroupingFields".equals(fieldName)) {
                    deserializedSearchMetadata.aggregatedGroupingFields = reader.getString();
                    continue;
                }
                if ("sum".equals(fieldName)) {
                    deserializedSearchMetadata.sum = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("max".equals(fieldName)) {
                    deserializedSearchMetadata.max = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedSearchMetadata.schema = SearchMetadataSchema.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSearchMetadata;
        });
    }
}

