/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SearchResults
implements JsonSerializable<SearchResults> {
    private String query;
    private String description;
    private Integer limit;
    private OffsetDateTime startSearchTime;
    private OffsetDateTime endSearchTime;
    private String sourceTable;
    private String azureAsyncOperationId;

    public String query() {
        return this.query;
    }

    public SearchResults withQuery(String query) {
        this.query = query;
        return this;
    }

    public String description() {
        return this.description;
    }

    public SearchResults withDescription(String description) {
        this.description = description;
        return this;
    }

    public Integer limit() {
        return this.limit;
    }

    public SearchResults withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public OffsetDateTime startSearchTime() {
        return this.startSearchTime;
    }

    public SearchResults withStartSearchTime(OffsetDateTime startSearchTime) {
        this.startSearchTime = startSearchTime;
        return this;
    }

    public OffsetDateTime endSearchTime() {
        return this.endSearchTime;
    }

    public SearchResults withEndSearchTime(OffsetDateTime endSearchTime) {
        this.endSearchTime = endSearchTime;
        return this;
    }

    public String sourceTable() {
        return this.sourceTable;
    }

    public String azureAsyncOperationId() {
        return this.azureAsyncOperationId;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("query", this.query);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeNumberField("limit", (Number)this.limit);
        jsonWriter.writeStringField("startSearchTime", this.startSearchTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startSearchTime));
        jsonWriter.writeStringField("endSearchTime", this.endSearchTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endSearchTime));
        return jsonWriter.writeEndObject();
    }

    public static SearchResults fromJson(JsonReader jsonReader) throws IOException {
        return (SearchResults)jsonReader.readObject(reader -> {
            SearchResults deserializedSearchResults = new SearchResults();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("query".equals(fieldName)) {
                    deserializedSearchResults.query = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSearchResults.description = reader.getString();
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedSearchResults.limit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("startSearchTime".equals(fieldName)) {
                    deserializedSearchResults.startSearchTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endSearchTime".equals(fieldName)) {
                    deserializedSearchResults.endSearchTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("sourceTable".equals(fieldName)) {
                    deserializedSearchResults.sourceTable = reader.getString();
                    continue;
                }
                if ("azureAsyncOperationId".equals(fieldName)) {
                    deserializedSearchResults.azureAsyncOperationId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSearchResults;
        });
    }
}

