/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.SearchSortEnum;
import java.io.IOException;

public final class SearchSort
implements JsonSerializable<SearchSort> {
    private String name;
    private SearchSortEnum order;

    public String name() {
        return this.name;
    }

    public SearchSort withName(String name) {
        this.name = name;
        return this;
    }

    public SearchSortEnum order() {
        return this.order;
    }

    public SearchSort withOrder(SearchSortEnum order) {
        this.order = order;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("order", this.order == null ? null : this.order.toString());
        return jsonWriter.writeEndObject();
    }

    public static SearchSort fromJson(JsonReader jsonReader) throws IOException {
        return (SearchSort)jsonReader.readObject(reader -> {
            SearchSort deserializedSearchSort = new SearchSort();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSearchSort.name = reader.getString();
                    continue;
                }
                if ("order".equals(fieldName)) {
                    deserializedSearchSort.order = SearchSortEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSearchSort;
        });
    }
}

