/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class StorageAccount
implements JsonSerializable<StorageAccount> {
    private String id;
    private String key;
    private static final ClientLogger LOGGER = new ClientLogger(StorageAccount.class);

    public String id() {
        return this.id;
    }

    public StorageAccount withId(String id) {
        this.id = id;
        return this;
    }

    public String key() {
        return this.key;
    }

    public StorageAccount withKey(String key) {
        this.key = key;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model StorageAccount"));
        }
        if (this.key() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property key in model StorageAccount"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("key", this.key);
        return jsonWriter.writeEndObject();
    }

    public static StorageAccount fromJson(JsonReader jsonReader) throws IOException {
        return (StorageAccount)jsonReader.readObject(reader -> {
            StorageAccount deserializedStorageAccount = new StorageAccount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedStorageAccount.id = reader.getString();
                    continue;
                }
                if ("key".equals(fieldName)) {
                    deserializedStorageAccount.key = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAccount;
        });
    }
}

