/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.StorageInsightInner;
import java.io.IOException;
import java.util.List;

public final class StorageInsightListResult
implements JsonSerializable<StorageInsightListResult> {
    private List<StorageInsightInner> value;
    private String odataNextLink;

    public List<StorageInsightInner> value() {
        return this.value;
    }

    public StorageInsightListResult withValue(List<StorageInsightInner> value) {
        this.value = value;
        return this;
    }

    public String odataNextLink() {
        return this.odataNextLink;
    }

    public StorageInsightListResult withOdataNextLink(String odataNextLink) {
        this.odataNextLink = odataNextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("@odata.nextLink", this.odataNextLink);
        return jsonWriter.writeEndObject();
    }

    public static StorageInsightListResult fromJson(JsonReader jsonReader) throws IOException {
        return (StorageInsightListResult)jsonReader.readObject(reader -> {
            StorageInsightListResult deserializedStorageInsightListResult = new StorageInsightListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedStorageInsightListResult.value = value = reader.readArray(reader1 -> StorageInsightInner.fromJson(reader1));
                    continue;
                }
                if ("@odata.nextLink".equals(fieldName)) {
                    deserializedStorageInsightListResult.odataNextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageInsightListResult;
        });
    }
}

