/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.StorageInsightState;
import java.io.IOException;

public final class StorageInsightStatus
implements JsonSerializable<StorageInsightStatus> {
    private StorageInsightState state;
    private String description;
    private static final ClientLogger LOGGER = new ClientLogger(StorageInsightStatus.class);

    public StorageInsightState state() {
        return this.state;
    }

    public StorageInsightStatus withState(StorageInsightState state) {
        this.state = state;
        return this;
    }

    public String description() {
        return this.description;
    }

    public StorageInsightStatus withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model StorageInsightStatus"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static StorageInsightStatus fromJson(JsonReader jsonReader) throws IOException {
        return (StorageInsightStatus)jsonReader.readObject(reader -> {
            StorageInsightStatus deserializedStorageInsightStatus = new StorageInsightStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedStorageInsightStatus.state = StorageInsightState.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedStorageInsightStatus.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageInsightStatus;
        });
    }
}

