/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.WorkspaceProperties;
import com.azure.resourcemanager.loganalytics.models.AzureEntityResource;
import com.azure.resourcemanager.loganalytics.models.Identity;
import com.azure.resourcemanager.loganalytics.models.PrivateLinkScopedResource;
import com.azure.resourcemanager.loganalytics.models.PublicNetworkAccessType;
import com.azure.resourcemanager.loganalytics.models.WorkspaceCapping;
import com.azure.resourcemanager.loganalytics.models.WorkspaceEntityStatus;
import com.azure.resourcemanager.loganalytics.models.WorkspaceFeatures;
import com.azure.resourcemanager.loganalytics.models.WorkspaceSku;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class WorkspacePatch
extends AzureEntityResource {
    private WorkspaceProperties innerProperties;
    private Identity identity;
    private Map<String, String> tags;
    private String etag;
    private String type;
    private String name;
    private String id;

    private WorkspaceProperties innerProperties() {
        return this.innerProperties;
    }

    public Identity identity() {
        return this.identity;
    }

    public WorkspacePatch withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public WorkspacePatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public WorkspaceEntityStatus provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String customerId() {
        return this.innerProperties() == null ? null : this.innerProperties().customerId();
    }

    public WorkspaceSku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public WorkspacePatch withSku(WorkspaceSku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public Integer retentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionInDays();
    }

    public WorkspacePatch withRetentionInDays(Integer retentionInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withRetentionInDays(retentionInDays);
        return this;
    }

    public WorkspaceCapping workspaceCapping() {
        return this.innerProperties() == null ? null : this.innerProperties().workspaceCapping();
    }

    public WorkspacePatch withWorkspaceCapping(WorkspaceCapping workspaceCapping) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withWorkspaceCapping(workspaceCapping);
        return this;
    }

    public String createdDate() {
        return this.innerProperties() == null ? null : this.innerProperties().createdDate();
    }

    public String modifiedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().modifiedDate();
    }

    public PublicNetworkAccessType publicNetworkAccessForIngestion() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccessForIngestion();
    }

    public WorkspacePatch withPublicNetworkAccessForIngestion(PublicNetworkAccessType publicNetworkAccessForIngestion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withPublicNetworkAccessForIngestion(publicNetworkAccessForIngestion);
        return this;
    }

    public PublicNetworkAccessType publicNetworkAccessForQuery() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccessForQuery();
    }

    public WorkspacePatch withPublicNetworkAccessForQuery(PublicNetworkAccessType publicNetworkAccessForQuery) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withPublicNetworkAccessForQuery(publicNetworkAccessForQuery);
        return this;
    }

    public Boolean forceCmkForQuery() {
        return this.innerProperties() == null ? null : this.innerProperties().forceCmkForQuery();
    }

    public WorkspacePatch withForceCmkForQuery(Boolean forceCmkForQuery) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withForceCmkForQuery(forceCmkForQuery);
        return this;
    }

    public List<PrivateLinkScopedResource> privateLinkScopedResources() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkScopedResources();
    }

    public WorkspaceFeatures features() {
        return this.innerProperties() == null ? null : this.innerProperties().features();
    }

    public WorkspacePatch withFeatures(WorkspaceFeatures features) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withFeatures(features);
        return this;
    }

    public String defaultDataCollectionRuleResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultDataCollectionRuleResourceId();
    }

    public WorkspacePatch withDefaultDataCollectionRuleResourceId(String defaultDataCollectionRuleResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceProperties();
        }
        this.innerProperties().withDefaultDataCollectionRuleResourceId(defaultDataCollectionRuleResourceId);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static WorkspacePatch fromJson(JsonReader jsonReader) throws IOException {
        return (WorkspacePatch)((Object)jsonReader.readObject(reader -> {
            WorkspacePatch deserializedWorkspacePatch = new WorkspacePatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkspacePatch.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkspacePatch.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkspacePatch.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedWorkspacePatch.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkspacePatch.innerProperties = WorkspaceProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedWorkspacePatch.identity = Identity.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedWorkspacePatch.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkspacePatch;
        }));
    }
}

