/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.WorkspacePurgeBodyFilters;
import java.io.IOException;
import java.util.List;

public final class WorkspacePurgeBody
implements JsonSerializable<WorkspacePurgeBody> {
    private String table;
    private List<WorkspacePurgeBodyFilters> filters;
    private static final ClientLogger LOGGER = new ClientLogger(WorkspacePurgeBody.class);

    public String table() {
        return this.table;
    }

    public WorkspacePurgeBody withTable(String table) {
        this.table = table;
        return this;
    }

    public List<WorkspacePurgeBodyFilters> filters() {
        return this.filters;
    }

    public WorkspacePurgeBody withFilters(List<WorkspacePurgeBodyFilters> filters) {
        this.filters = filters;
        return this;
    }

    public void validate() {
        if (this.table() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property table in model WorkspacePurgeBody"));
        }
        if (this.filters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property filters in model WorkspacePurgeBody"));
        }
        this.filters().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("table", this.table);
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static WorkspacePurgeBody fromJson(JsonReader jsonReader) throws IOException {
        return (WorkspacePurgeBody)jsonReader.readObject(reader -> {
            WorkspacePurgeBody deserializedWorkspacePurgeBody = new WorkspacePurgeBody();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("table".equals(fieldName)) {
                    deserializedWorkspacePurgeBody.table = reader.getString();
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    List filters;
                    deserializedWorkspacePurgeBody.filters = filters = reader.readArray(reader1 -> WorkspacePurgeBodyFilters.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkspacePurgeBody;
        });
    }
}

